<?php
// controllers/AboutController.php

// Pastikan BaseController di-include
require_once dirname(__DIR__) . '/controllers/BaseController.php';
// Include models yang dibutuhkan oleh AboutController
require_once dirname(__DIR__) . '/models/Users.php';
require_once dirname(__DIR__) . '/models/Studio.php';
require_once dirname(__DIR__) . '/models/Kategori.php';
require_once dirname(__DIR__) . '/models/Film.php';

class AboutController extends BaseController {

    public function __construct(mysqli $conn) {
        parent::__construct($conn);
    }

    public function index() {
        $userModel = new Users($this->conn);
        $studioModel = new Studio($this->conn);
        $kategoriModel = new Kategori($this->conn);
        $filmModel = new Film($this->conn);

        // Ambil data untuk bagian "Testimonials"
        // Anda mungkin hanya ingin user dengan role 'user' atau user yang punya review
        $data_users = $userModel->getAllUsers(); 

        // Ambil jumlah total untuk bagian "Counts"
        // Idealnya, tambahkan metode countAll() di setiap model untuk efisiensi
        $total_users = count($userModel->getAllUsers()); // Perlu perbaikan jika datanya banyak
        $total_studios = count($studioModel->getAllStudios());
        $total_kategoris = count($kategoriModel->getAllKategoris());
        $total_films = count($filmModel->getAllFilms());

        // Siapkan data untuk diteruskan ke view
        $data = [
            'data_users' => $data_users, 
            'total_users' => $total_users,
            'total_studios' => $total_studios,
            'total_kategoris' => $total_kategoris,
            'total_films' => $total_films
        ];

        // Load view about.php
        $this->view('about', $data);
    }
}
