<?php

namespace App\Controllers;
require_once 'BaseController.php';
use App\Controllers\BaseController;

include_once '../koneksi.php';
include_once '../models/Tiket.php';

class TiketController extends BaseController
{
    private $tiketModel;

    public function __construct()
    {
        parent::__construct();
        $this->tiketModel = new \Tiket();
    }

    public function processRequest()
    {
        $tombol = $_REQUEST['proses'] ?? '';

        $harga = $this->sanitizeInput($_POST['harga'] ?? '');
        $stok = $this->sanitizeInput($_POST['stok'] ?? '');
        $kursi_id = $this->sanitizeInput($_POST['kursi_id'] ?? '');
        $film_id = $this->sanitizeInput($_POST['film_id'] ?? '');
        $idx = $this->sanitizeInput($_POST['idx'] ?? '');

        $data = [
            $harga,
            $stok,
            $kursi_id,
            $film_id
        ];

        switch ($tombol) {
            case 'simpan':
                if (empty($harga) || empty($stok) || empty($kursi_id) || empty($film_id)) {
                    $this->redirect('../index.php?hal=tiket_form', 'Semua kolom harus diisi.', 'error');
                }
                $this->tiketModel->simpan($data);
                $this->redirect('../index.php?hal=tiket', 'Data tiket berhasil disimpan!', 'success');
                break;

            case 'ubah':
                if (empty($harga) || empty($stok) || empty($kursi_id) || empty($film_id) || empty($idx)) {
                    $this->redirect('../index.php?hal=tiket_form_update&idedit=' . $idx, 'Semua kolom harus diisi.', 'error');
                }
                $data[] = $idx;
                $this->tiketModel->ubah($data);
                $this->redirect('../index.php?hal=tiket', 'Data tiket berhasil diubah!', 'success');
                break;

            case 'hapus':
                if (empty($idx)) {
                    $this->redirect('../index.php?hal=tiket', 'ID tiket tidak ditemukan.', 'error');
                }
                $this->tiketModel->hapus($idx);
                $this->redirect('../index.php?hal=tiket', 'Data tiket berhasil dihapus!', 'success');
                break;

            default:
                $this->redirect('../index.php?hal=tiket');
                break;
        }
    }
}

$controller = new TiketController();
$controller->processRequest();