<?php
// views/about.php
// View ini seharusnya menerima data dari controller.
// Contoh: $data_users (dari UserController/AboutController),
// $total_users, $total_studios, $total_kategoris, $total_films

// Pesan sukses atau error dari sesi (jika ada)
if (isset($_SESSION['error_message'])) {
    echo "<p class='message error'>" . htmlspecialchars($_SESSION['error_message']) . "</p>";
    unset($_SESSION['error_message']);
}
if (isset($_SESSION['success_message'])) {
    echo "<p class='message success'>" . htmlspecialchars($_SESSION['success_message']) . "</p>";
    unset($_SESSION['success_message']);
}

// Pastikan variabel data tersedia, jika tidak, set default atau kosong
$total_users = $total_users ?? 0;
$total_studios = $total_studios ?? 0;
$total_kategoris = $total_kategoris ?? 0;
$total_films = $total_films ?? 0;
$data_users = $data_users ?? []; // Untuk bagian testimonials
?>

<section id="breadcrumbs" class="breadcrumbs-section">
    <div class="container">
        <ol class="breadcrumb-list">
            <li><a href="index.php?hal=home">Home</a></li>
            <li>About Us</li>
        </ol>
        <h2 class="section-heading">About Us</h2>
    </div>
</section>

<section id="about" class="about-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 about-image-col">
                <img src="assets/img/about2.jpg" class="img-fluid about-image" alt="About Us">
            </div>
            <div class="col-lg-6 about-content-col">
                <h3 class="content-title">Sistem Pemesanan Tiket Bioskop</h3>
                <p class="location-text">Bekasi, Jawa Barat</p>
                <p class="italic-text">
                    Aplikasi ini menyediakan berbagai informasi mengenai film terbaru dan sistem pemesanan tiket yang mudah.
                </p>
                <ul class="feature-list">
                    <li><i class="bi bi-check-circle-fill feature-icon"></i> Terdapat banyak pilihan film terbaru</li>
                    <li><i class="bi bi-check-circle-fill feature-icon"></i> Pemesanan tiket menjadi lebih mudah dan cepat</li>
                    <li><i class="bi bi-check-circle-fill feature-icon"></i> Tersedia berbagai pilihan studio dan tiket dengan harga terjangkau</li>
                </ul>
                <p class="main-description">
                    Nikmati film dan hiburan terbaik langsung dari kenyamanan Anda! Tetaplah terinformasi dengan berita terbaru seputar film dan jangan lewatkan penawaran serta promo menarik yang kami sediakan.
                </p>
                <p class="call-to-action-text">Yuk, tunggu apa lagi? Pesan tiketmu sekarang!</p>
            </div>
        </div>
    </div>
</section>

<section id="counts" class="counts-section">
    <div class="container">
        <div class="row gx-4 gy-4">
            <div class="col-lg-3 col-md-6 d-flex align-items-stretch">
                <div class="count-box">
                    <i class="bi bi-emoji-smile count-icon"></i>
                    <span data-purecounter-start="0" data-purecounter-end="<?= htmlspecialchars($total_users) ?>" data-purecounter-duration="1" class="purecounter count-number"></span>
                    <p class="count-label"><strong>Pengguna</strong> Bioskop</p>
                    <a href="index.php?hal=user" class="count-link">Lihat Selengkapnya &raquo;</a>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 d-flex align-items-stretch">
                <div class="count-box">
                    <i class="bi bi-display count-icon"></i> <span data-purecounter-start="0" data-purecounter-end="<?= htmlspecialchars($total_studios) ?>" data-purecounter-duration="1" class="purecounter count-number"></span>
                    <p class="count-label"><strong>Studio</strong> Bioskop</p>
                    <a href="index.php?hal=studio" class="count-link">Lihat Selengkapnya &raquo;</a>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 d-flex align-items-stretch">
                <div class="count-box">
                    <i class="bi bi-tags-fill count-icon"></i> <span data-purecounter-start="0" data-purecounter-end="<?= htmlspecialchars($total_kategoris) ?>" data-purecounter-duration="1" class="purecounter count-number"></span>
                    <p class="count-label"><strong>Kategori</strong> Film</p>
                    <a href="index.php?hal=kategori" class="count-link">Lihat Selengkapnya &raquo;</a>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 d-flex align-items-stretch">
                <div class="count-box">
                    <i class="bi bi-camera-reels-fill count-icon"></i> <span data-purecounter-start="0" data-purecounter-end="<?= htmlspecialchars($total_films) ?>" data-purecounter-duration="1" class="purecounter count-number"></span>
                    <p class="count-label"><strong>Film</strong> Bioskop</p>
                    <a href="index.php?hal=film" class="count-link">Lihat Selengkapnya &raquo;</a>
                </div>
            </div>
        </div>
    </div>
</section>

<section id="testimonials" class="testimonials-section">
    <div class="container">
        <div class="section-title-wrapper">
            <h2 class="section-heading">Testimonials</h2>
            <p class="section-subtitle">Dengar pengalaman luar biasa dari pengguna setia kami.</p>
        </div>
        <div class="row justify-content-center">
            <?php if (!empty($data_users)): ?>
                <?php foreach($data_users as $row): ?>
                    <div class="col-lg-6 col-md-6">
                        <div class="testimonial-item">
                            <img src="<?= htmlspecialchars($row['foto'] ?? 'assets/profile/default.jpg') ?>" class="testimonial-img" alt="Profile Picture">
                            <h3 class="testimonial-name"><?= htmlspecialchars($row['fullname'] ?? 'Nama Pengguna') ?></h3>
                            <h6 class="testimonial-role-email"><?= htmlspecialchars($row['email'] ?? '') ?></h6>
                            <h6 class="testimonial-role-email"><?= htmlspecialchars(ucfirst($row['role'] ?? 'Pengguna')) ?></h6>
                            <p class="testimonial-quote">
                                <i class="bi bi-quote quote-icon-left"></i>
                                Luar Biasa! Sistem pemesanan tiket bioskop ini sangat bermanfaat dan mudah digunakan. Sangat direkomendasikan!
                                <i class="bi bi-quote quote-icon-right"></i>
                            </p>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="col-12">
                    <p class="empty-message">Belum ada testimonial pengguna yang ditampilkan saat ini.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<style>
    /* Global/Base Styles (Consistent across all views) */
    body {
        font-family: 'Poppins', sans-serif;
        background-color: #f0f2f5;
        color: #333;
        line-height: 1.6;
        margin: 0;
        padding: 0;
    }

    /* Message Styling (Success/Error) - Consistent across views */
    .message {
        padding: 12px 20px;
        margin: 20px auto;
        border-radius: 8px;
        text-align: center;
        font-weight: 600;
        max-width: 900px;
        box-sizing: border-box;
        animation: fadeInDown 0.5s ease-out;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    @keyframes fadeInDown {
        from { opacity: 0; transform: translateY(-20px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .message.error {
        background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb;
    }
    .message.success {
        background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb;
    }

    /* Section Styling */
    section {
        padding: 60px 0;
        overflow: hidden;
        background-color: #ffffff; /* Default background for sections */
        margin-bottom: 30px; /* Space between sections */
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.05);
    }
    section:first-of-type { /* Breadcrumbs */
        margin-top: 20px;
    }
    section:last-of-type { /* Testimonials */
        margin-bottom: 0;
    }
    
    .container {
        max-width: 1200px; /* Lebar container utama */
        margin: 0 auto;
        padding: 0 15px;
    }
    .row {
        display: flex;
        flex-wrap: wrap;
        margin: -15px; /* Kompensasi padding kolom */
    }
    .col-lg-6, .col-md-6, .col-lg-3, .col-12 {
        padding: 15px; /* Spacing internal kolom */
        box-sizing: border-box;
    }
    .d-flex { display: flex; }
    .align-items-stretch { align-items: stretch; }
    .justify-content-center { justify-content: center; }
    .pt-4 { padding-top: 1.5rem; }
    .pt-lg-0 { padding-top: 0; }
    .img-fluid { max-width: 100%; height: auto; }


    /* Breadcrumbs Section */
    .breadcrumbs-section {
        background-color: #e9ecef;
        padding: 20px 0;
        border-radius: 8px;
        box-shadow: none; /* No shadow for breadcrumbs */
    }
    .breadcrumb-list {
        display: flex;
        padding: 0;
        margin: 0 0 10px 0;
        list-style: none;
        font-size: 0.9em;
    }
    .breadcrumb-list li {
        color: #6c757d;
    }
    .breadcrumb-list li + li::before {
        content: "/";
        padding: 0 8px;
        color: #adb5bd;
    }
    .breadcrumb-list a {
        color: #007bff;
        text-decoration: none;
        transition: color 0.2s ease;
    }
    .breadcrumb-list a:hover {
        color: #0056b3;
    }
    .breadcrumbs-section .section-heading {
        color: #343a40;
        font-size: 2em;
        font-weight: 700;
        margin: 0;
    }

    /* About Section */
    .about-section .about-image-col {
        padding: 30px;
    }
    .about-image {
        border-radius: 12px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    }
    .about-content-col {
        padding: 30px;
    }
    .content-title {
        font-size: 2.2em;
        font-weight: 700;
        color: #1a2a3a;
        margin-bottom: 10px;
        position: relative;
        padding-bottom: 10px;
    }
    .content-title::after {
        content: '';
        width: 50px;
        height: 3px;
        background-color: #007bff;
        position: absolute;
        bottom: 0;
        left: 0;
        border-radius: 2px;
    }
    .location-text {
        font-size: 1.1em;
        color: #6a737d;
        margin-bottom: 20px;
    }
    .italic-text {
        font-style: italic;
        color: #555;
        margin-bottom: 20px;
    }
    .feature-list {
        list-style: none;
        padding: 0;
        margin-bottom: 25px;
    }
    .feature-list li {
        padding: 8px 0;
        color: #343a40;
        font-size: 1em;
        display: flex;
        align-items: center;
    }
    .feature-icon {
        color: #28a745; /* Green checkmark */
        font-size: 1.2em;
        margin-right: 10px;
        flex-shrink: 0;
    }
    .main-description {
        color: #555;
        margin-bottom: 25px;
    }
    .call-to-action-text {
        font-weight: 600;
        font-size: 1.1em;
        color: #007bff;
    }

    /* Counts Section */
    .counts-section {
        background-color: #f8f9fa; /* Light background for this section */
        text-align: center;
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.08);
        padding: 40px 0; /* Adjust padding for counts */
    }
    .count-box {
        padding: 30px 20px;
        background-color: #ffffff;
        border-radius: 10px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        transition: all 0.3s ease;
        height: 100%; /* Agar kotak sama tinggi */
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        border: 1px solid #eee;
    }
    .count-box:hover {
        transform: translateY(-5px);
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    }
    .count-icon {
        font-size: 3em;
        color: #007bff;
        margin-bottom: 15px;
    }
    .count-number {
        font-size: 2.5em;
        font-weight: 700;
        color: #1a2a3a;
        margin-bottom: 5px;
        line-height: 1;
    }
    .count-label {
        font-size: 1.05em;
        color: #6a737d;
        margin-bottom: 15px;
    }
    .count-link {
        color: #007bff;
        text-decoration: none;
        font-weight: 600;
        font-size: 0.9em;
        transition: color 0.2s ease;
    }
    .count-link:hover {
        color: #0056b3;
    }

    /* Clients Section */
    .clients-section {
        background-color: #ffffff;
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.08);
    }
    .section-title-wrapper {
        text-align: center;
        margin-bottom: 40px;
    }
    .section-heading {
        font-size: 2.5em;
        font-weight: 700;
        color: #1a2a3a;
        margin-bottom: 10px;
    }
    .section-subtitle {
        font-size: 1.1em;
        color: #6a737d;
    }
    .clients-slider .swiper-slide {
        text-align: center;
        opacity: 0.6;
        transition: all 0.3s ease;
    }
    .clients-slider .swiper-slide:hover {
        opacity: 1;
    }
    .client-logo {
        max-width: 120px;
        filter: grayscale(100%);
        transition: all 0.3s ease;
    }
    .clients-slider .swiper-slide:hover .client-logo {
        filter: none;
    }
    /* Swiper navigation/pagination styles need to be defined by Swiper's CSS library */

    /* Testimonials Section */
    .testimonials-section {
        background-color: #f8f9fa;
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.08);
    }
    .testimonial-item {
        background-color: #ffffff;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        margin-bottom: 30px;
        text-align: center;
        border: 1px solid #eee;
        height: 100%; /* Agar kotak sama tinggi */
    }
    .testimonial-img {
        width: 90px;
        height: 90px;
        border-radius: 50%;
        margin: 0 auto 15px auto;
        border: 4px solid #007bff;
        object-fit: cover;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
    .testimonial-name {
        font-size: 1.4em;
        font-weight: 600;
        color: #333;
        margin-bottom: 5px;
    }
    .testimonial-role-email {
        font-size: 0.9em;
        color: #6a737d;
        margin-bottom: 5px;
    }
    .testimonial-quote {
        font-style: italic;
        color: #555;
        margin-top: 15px;
        line-height: 1.7;
        position: relative;
        padding: 0 15px;
    }
    .quote-icon-left, .quote-icon-right {
        font-size: 1.8em;
        color: #007bff;
        position: absolute;
        opacity: 0.2;
    }
    .quote-icon-left {
        left: 0;
        top: 0;
        transform: translateY(-50%);
    }
    .quote-icon-right {
        right: 0;
        bottom: 0;
        transform: translateY(50%) rotate(180deg);
    }
    .empty-message {
        text-align: center;
        color: #666;
        padding: 30px;
        background-color: #fefefe;
        border: 1px dashed #e0e0e0;
        border-radius: 10px;
    }

    /* Responsive Adjustments */
    @media (max-width: 992px) { /* Medium screens */
        .col-lg-6 { flex: 0 0 100%; max-width: 100%; }
        .about-image-col { text-align: center; }
        .about-image { margin: 0 auto; }
        .about-content-col { order: -1; /* Pindahkan konten ke atas gambar di mobile */ }
        .counts-section .col-lg-3 { flex: 0 0 50%; max-width: 50%; } /* 2 kolom di tablet */
        .testimonials-section .col-lg-6 { flex: 0 0 100%; max-width: 100%; } /* 1 kolom di tablet */
    }

    @media (max-width: 768px) { /* Small screens */
        section {
            padding: 40px 0;
            margin-bottom: 20px;
        }
        .container {
            padding: 0 10px;
        }
        .row {
            margin: -10px;
        }
        .col-lg-6, .col-md-6, .col-lg-3, .col-12 {
            padding: 10px;
        }
        .section-heading {
            font-size: 2em;
        }
        .section-subtitle {
            font-size: 1em;
        }
        .content-title {
            font-size: 1.8em;
        }
        .location-text, .italic-text, .main-description, .call-to-action-text {
            font-size: 0.95em;
        }
        .feature-icon {
            font-size: 1em;
        }
        .count-box {
            padding: 20px 15px;
        }
        .count-icon {
            font-size: 2.5em;
        }
        .count-number {
            font-size: 2em;
        }
        .count-label {
            font-size: 0.95em;
        }
        .count-link {
            font-size: 0.8em;
        }
        .client-logo {
            max-width: 80px;
        }
        .testimonial-img {
            width: 70px;
            height: 70px;
        }
        .testimonial-name {
            font-size: 1.2em;
        }
        .testimonial-role-email {
            font-size: 0.8em;
        }
        .testimonial-quote {
            font-size: 0.9em;
            padding: 0 10px;
        }
        .quote-icon-left, .quote-icon-right {
            font-size: 1.5em;
        }
    }

    @media (max-width: 576px) { /* Extra small screens */
        .counts-section .col-lg-3 { flex: 0 0 100%; max-width: 100%; } /* 1 kolom di HP */
    }
</style>