<?php
// views/blog.php
// View ini menampilkan halaman Blog.
// Variabel yang diharapkan:
// - $total_users (int) - Meskipun tidak dipakai di sini lagi, tetap ada dari controller.
// - $total_studios (int)
// - $total_kategoris (int)
// - $total_films (int)
// Variabel-variabel ini disediakan oleh BlogController->index()

// Pesan sukses atau error dari sesi (jika ada)
if (isset($_SESSION['error_message'])) {
    echo "<p class='message error'>" . htmlspecialchars($_SESSION['error_message']) . "</p>";
    unset($_SESSION['error_message']);
}
if (isset($_SESSION['success_message'])) {
    echo "<p class='message success'>" . htmlspecialchars($_SESSION['success_message']) . "</p>";
    unset($_SESSION['success_message']);
}

// Cek status login dan peran pengguna
$is_admin = isset($_SESSION['user_id']) && $_SESSION['user_role'] === 'admin';

// Pastikan variabel data tersedia, jika tidak, set default atau kosong
// Variabel ini sebenarnya tidak lagi digunakan di view ini setelah section counts dihapus.
$total_users = $total_users ?? 0;
$total_studios = $total_studios ?? 0;
$total_kategoris = $total_kategoris ?? 0;
$total_films = $total_films ?? 0;
?>

<section id="breadcrumbs" class="breadcrumbs-section">
    <div class="container">
        <ol class="breadcrumb-list">
            <li><a href="index.php?hal=home">Home</a></li>
            <li>Blog</li>
        </ol>
        <h2 class="section-heading">Blog Kami</h2>
    </div>
</section>

<section id="blog-main-content" class="blog-main-content-section">
    <div class="container">
        <h1 class="page-title">Artikel Terbaru</h1>
        <p class="page-description">Temukan ulasan film, tips pemesanan, dan berita terbaru dari dunia perfilman.</p>

        <div class="row">
            <div class="col-lg-6 col-md-6 blog-post-col">
                <div class="blog-post-card">
                    <img src="assets/img/blog/film_terbaru_large.jpg" alt="Film Terbaru" class="blog-post-image">
                    <div class="blog-post-body">
                        <h2 class="blog-post-title">Film Terbaru yang Wajib Ditonton!</h2>
                        <p class="blog-post-meta">Diposting pada: 23 Juni 2025</p>
                        <p class="blog-post-excerpt">
                            Nantikan ulasan kami tentang film-film blockbuster yang akan datang! Dari aksi mendebarkan hingga drama yang menguras emosi, kami akan memberikan semua informasi yang Anda butuhkan sebelum Anda memesan tiket. Ikuti terus blog kami untuk rekomendasi terbaik dan berita terkini dari dunia perfilman.
                        </p>
                        <a href="index.php?hal=blog_detail&id=1" class="read-more-btn">Baca Selengkapnya »</a>
                    </div>
                </div>
            </div>

            <div class="col-lg-6 col-md-6 blog-post-col">
                <div class="blog-post-card">
                    <img src="assets/img/blog/tips_pesan_tiket_large.jpg" alt="Tips Pesan Tiket" class="blog-post-image">
                    <div class="blog-post-body">
                        <h2 class="blog-post-title">Tips Memesan Tiket Bioskop Online</h2>
                        <p class="blog-post-meta">Diposting pada: 20 Juni 2025</p>
                        <p class="blog-post-excerpt">
                            Ingin pengalaman memesan tiket yang mulus dan cepat? Pelajari tips dan trik kami untuk memilih kursi terbaik, memanfaatkan promo, dan menghindari antrean panjang. Proses pemesanan tiket bioskop kini semudah sentuhan jari!
                        </p>
                        <a href="index.php?hal=blog_detail&id=2" class="read-more-btn">Baca Selengkapnya »</a>
                    </div>
                </div>
            </div>

            <div class="col-12 text-center mt-4">
                <p class="coming-soon-message">Lebih banyak postingan segera hadir!</p>
            </div>
        </div>
    </div>
</section>

<section id="testimonials" class="testimonials-section">
    <div class="container">
        <div class="section-title-wrapper">
            <h2 class="section-heading">Apa Kata Mereka</h2>
            <p class="section-subtitle">Dengar pengalaman luar biasa dari pengguna setia kami.</p>
        </div>
        <div class="row justify-content-center">
            <?php 
            // Variabel $data_users harusnya disediakan oleh controller untuk testimonial
            // Untuk blog ini, kita set manual jika tidak ada
            $blog_users_for_testimonials = [
                ['fullname' => 'Alice Smith', 'email' => 'alice@example.com', 'role' => 'pengguna', 'foto' => 'assets/profile/default.jpg'],
                ['fullname' => 'Bob Johnson', 'email' => 'bob@example.com', 'role' => 'pengguna', 'foto' => 'assets/profile/default.jpg'],
                // Tambahkan lebih banyak dummy data jika perlu
            ];
            if (!empty($blog_users_for_testimonials)): ?>
                <?php foreach($blog_users_for_testimonials as $row): ?>
                    <div class="col-lg-6 col-md-6">
                        <div class="testimonial-item">
                            <img src="<?= htmlspecialchars($row['foto'] ?? 'assets/profile/default.jpg') ?>" class="testimonial-img" alt="Profile Picture">
                            <h3 class="testimonial-name"><?= htmlspecialchars($row['fullname'] ?? 'Nama Pengguna') ?></h3>
                            <h6 class="testimonial-role-email"><?= htmlspecialchars($row['email'] ?? '') ?></h6>
                            <h6 class="testimonial-role-email"><?= htmlspecialchars(ucfirst($row['role'] ?? 'Pengguna')) ?></h6>
                            <p class="testimonial-quote">
                                <i class="bi bi-quote quote-icon-left"></i>
                                Luar Biasa! Sistem pemesanan tiket bioskop ini sangat bermanfaat dan mudah digunakan. Sangat direkomendasikan!
                                <i class="bi bi-quote quote-icon-right"></i>
                            </p>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="col-12">
                    <p class="empty-message">Belum ada testimonial pengguna yang ditampilkan saat ini.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<style>
    /* Global/Base Styles (Consistent across all views) */
    body {
        font-family: 'Poppins', sans-serif;
        background-color: #f0f2f5;
        color: #333;
        line-height: 1.6;
        margin: 0;
        padding: 0;
    }

    /* Message Styling (Success/Error) - Consistent across views */
    .message {
        padding: 12px 20px;
        margin: 20px auto;
        border-radius: 8px;
        text-align: center;
        font-weight: 600;
        max-width: 900px;
        box-sizing: border-box;
        animation: fadeInDown 0.5s ease-out;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    @keyframes fadeInDown {
        from { opacity: 0; transform: translateY(-20px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .message.error {
        background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb;
    }
    .message.success {
        background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb;
    }

    /* Section Styling (Consistent across all views) */
    section {
        padding: 60px 0;
        overflow: hidden;
        background-color: #ffffff; /* Default background for sections */
        margin-bottom: 30px; /* Space between sections */
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.05);
    }
    section:first-of-type { /* Breadcrumbs */
        margin-top: 20px;
    }
    section:last-of-type { /* Testimonials */
        margin-bottom: 0;
    }
    
    .container {
        max-width: 1200px; /* Lebar container utama */
        margin: 0 auto;
        padding: 0 15px;
    }
    .row {
        display: flex;
        flex-wrap: wrap;
        margin: -15px; /* Kompensasi padding kolom */
    }
    .col-lg-6, .col-md-6, .col-lg-3, .col-12 {
        padding: 15px; /* Spacing internal kolom */
        box-sizing: border-box;
    }
    .d-flex { display: flex; }
    .align-items-stretch { align-items: stretch; }
    .justify-content-center { justify-content: center; }
    .pt-4 { padding-top: 1.5rem; }
    .pt-lg-0 { padding-top: 0; }
    .img-fluid { max-width: 100%; height: auto; }


    /* Breadcrumbs Section (Consistent across views) */
    .breadcrumbs-section {
        background-color: #e9ecef;
        padding: 20px 0;
        border-radius: 8px;
        box-shadow: none;
    }
    .breadcrumb-list {
        display: flex;
        padding: 0;
        margin: 0 0 10px 0;
        list-style: none;
        font-size: 0.9em;
    }
    .breadcrumb-list li {
        color: #6c757d;
    }
    .breadcrumb-list li + li::before {
        content: "/";
        padding: 0 8px;
        color: #adb5bd;
    }
    .breadcrumb-list a {
        color: #007bff;
        text-decoration: none;
        transition: color 0.2s ease;
    }
    .breadcrumb-list a:hover {
        color: #0056b3;
    }
    .breadcrumbs-section .section-heading {
        color: #343a40;
        font-size: 2em;
        font-weight: 700;
        margin: 0;
    }

    /* Blog Main Content Section */
    .blog-main-content-section {
        background-color: #f8f9fa;
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.08);
    }
    .blog-main-content-section .page-title {
        font-size: 2.5em;
        font-weight: 700;
        margin-bottom: 10px;
        padding-bottom: 15px;
    }
    .blog-main-content-section .page-description {
        margin-bottom: 40px;
    }

    .blog-post-col {
        margin-bottom: 30px;
    }

    .blog-post-card {
        background-color: #ffffff;
        border-radius: 10px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        overflow: hidden;
        height: 100%;
        display: flex;
        flex-direction: column;
        transition: transform 0.2s ease, box-shadow 0.2s ease;
    }
    .blog-post-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }

    .blog-post-image {
        width: 100%;
        height: 250px;
        object-fit: cover;
        display: block;
    }

    .blog-post-body {
        padding: 20px;
        flex-grow: 1;
        display: flex;
        flex-direction: column;
    }

    .blog-post-title {
        font-size: 1.6em;
        color: #007bff;
        margin-top: 0;
        margin-bottom: 10px;
        line-height: 1.3;
        font-weight: 600;
    }

    .blog-post-meta {
        font-size: 0.85em;
        color: #888;
        margin-bottom: 15px;
    }

    .blog-post-excerpt {
        font-size: 0.95em;
        color: #555;
        line-height: 1.6;
        margin-bottom: 20px;
        flex-grow: 1;
    }

    .read-more-btn {
        background-color: #f0f0f0;
        color: #007bff;
        padding: 8px 15px;
        border-radius: 20px;
        text-decoration: none;
        font-weight: 600;
        font-size: 0.9em;
        align-self: flex-start;
        transition: background-color 0.2s ease, color 0.2s ease;
        border: 1px solid #ddd;
    }
    .read-more-btn:hover {
        background-color: #e0e0e0;
        color: #0056b3;
    }

    .coming-soon-message {
        font-size: 1.1em;
        color: #666;
        padding: 30px 0;
        border-top: 1px dashed #eee;
        margin-top: 30px;
    }

    /* Testimonials Section (Consistent with About Us) */
    .testimonials-section {
        background-color: #f8f9fa;
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.08);
    }
    .section-title-wrapper {
        text-align: center;
        margin-bottom: 40px;
    }
    .section-heading {
        font-size: 2.5em;
        font-weight: 700;
        color: #1a2a3a;
        margin-bottom: 10px;
    }
    .section-subtitle {
        font-size: 1.1em;
        color: #6a737d;
    }
    .testimonial-item {
        background-color: #ffffff;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        margin-bottom: 30px;
        text-align: center;
        border: 1px solid #eee;
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
    }
    .testimonial-img {
        width: 90px;
        height: 90px;
        border-radius: 50%;
        margin: 0 auto 15px auto;
        border: 4px solid #007bff;
        object-fit: cover;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
    .testimonial-name {
        font-size: 1.4em;
        font-weight: 600;
        color: #333;
        margin-bottom: 5px;
    }
    .testimonial-role-email {
        font-size: 0.9em;
        color: #6a737d;
        margin-bottom: 5px;
    }
    .testimonial-quote {
        font-style: italic;
        color: #555;
        margin-top: 15px;
        line-height: 1.7;
        position: relative;
        padding: 0 15px;
        flex-grow: 1;
        display: flex;
        align-items: center;
    }
    .quote-icon-left, .quote-icon-right {
        font-size: 1.8em;
        color: #007bff;
        position: absolute;
        opacity: 0.2;
    }
    .quote-icon-left {
        left: 0;
        top: 0;
        transform: translateY(-50%);
    }
    .quote-icon-right {
        right: 0;
        bottom: 0;
        transform: translateY(50%) rotate(180deg);
    }
    .empty-message {
        text-align: center;
        color: #666;
        padding: 30px;
        background-color: #fefefe;
        border: 1px dashed #e0e0e0;
        border-radius: 10px;
    }

    /* Responsive Adjustments */
    @media (max-width: 992px) {
        .col-lg-6 { flex: 0 0 100%; max-width: 100%; }
        .col-md-6 { flex: 0 0 50%; max-width: 50%; }
        .blog-post-card { margin-bottom: 20px; }
    }

    @media (max-width: 768px) {
        section {
            padding: 40px 0;
            margin-bottom: 20px;
        }
        .container {
            padding: 0 10px;
        }
        .row {
            margin: -10px;
        }
        .col-lg-6, .col-md-6, .col-lg-3, .col-12 {
            padding: 10px;
        }
        .section-heading {
            font-size: 2em;
        }
        .section-subtitle {
            font-size: 1em;
        }
        .breadcrumbs-section .section-heading {
            font-size: 1.8em;
        }
        .blog-main-content-section .page-title {
            font-size: 2em;
        }
        .blog-main-content-section .page-description {
            font-size: 0.9em;
        }
        .blog-post-title {
            font-size: 1.4em;
        }
        .blog-post-excerpt, .blog-post-meta {
            font-size: 0.9em;
        }
        .read-more-btn {
            font-size: 0.8em;
            padding: 6px 12px;
        }
        /* Counts section is removed, so no need for its media queries */
        .testimonials-section .col-lg-6 {
            flex: 0 0 100%; max-width: 100%;
            margin-bottom: 20px;
        }
        .testimonials-section .col-lg-6:last-of-type {
            margin-bottom: 0;
        }
        .testimonial-item {
            padding: 20px 15px;
        }
        .testimonial-img { width: 60px; height: 60px; }
        .testimonial-name { font-size: 1.1em; }
        .testimonial-role-email { font-size: 0.8em; }
        .testimonial-quote { font-size: 0.85em; }
        .quote-icon-left, .quote-icon-right { font-size: 1.5em; }
    }

    @media (max-width: 480px) {
        .blog-post-image {
            height: 180px;
        }
        .blog-post-title {
            font-size: 1.2em;
        }
    }
</style>