<?php
// views/blog_detail.php
// View ini menampilkan halaman detail untuk sebuah postingan blog.
// Variabel yang diharapkan: $blog_id (int)
// Variabel ini disediakan oleh BlogController->detail()

// Pesan sukses atau error dari sesi (jika ada)
if (isset($_SESSION['error_message'])) {
    echo "<p class='message error'>" . htmlspecialchars($_SESSION['error_message']) . "</p>";
    unset($_SESSION['error_message']);
}
if (isset($_SESSION['success_message'])) {
    echo "<p class='message success'>" . htmlspecialchars($_SESSION['success_message']) . "</p>";
    unset($_SESSION['success_message']);
}

// --- DATA STATIS UNTUK BLOG POSTS ---
// Ini adalah array yang berisi konten untuk setiap blog post berdasarkan ID.
// Jika nanti kamu punya database blog, data ini akan diambil dari sana.
$blog_posts = [
    1 => [
        'title' => 'Film Terbaru yang Wajib Ditonton!',
        'date' => '23 Juni 2025',
        'author' => 'Admin Bioskop',
        'image' => 'assets/img/blog/film_terbaru_large.jpg', // Path gambar lebih besar untuk detail
        'content' => 'Nantikan ulasan kami tentang film-film blockbuster yang akan datang! Dari aksi mendebarkan hingga drama yang menguras emosi, kami akan memberikan semua informasi yang Anda butuhkan sebelum Anda memesan tiket. Ikuti terus blog kami untuk rekomendasi terbaik dan berita terkini dari dunia perfilman.<br><br>Setiap bulannya, industri perfilman selalu menyajikan kejutan-kejutan baru yang tak henti-hentinya memukau penonton. Dari sekuel yang dinantikan hingga karya orisinal yang berani, daftar film yang harus ditonton terus bertambah. Kami akan menyelami detail produksi, menyoroti penampilan aktor, dan membahas potensi dampak film tersebut di kancah perfilman dunia. Jangan sampai ketinggalan informasi paling aktual agar Anda selalu siap menikmati sinema terbaik yang ada.<br><br>Selain ulasan mendalam, kami juga akan memberikan tips praktis tentang bagaimana memaksimalkan pengalaman menonton Anda. Mulai dari memilih tempat duduk yang strategis, memanfaatkan diskon tiket, hingga mencari tahu fasilitas terbaik di bioskop favorit Anda. Persiapkan diri Anda untuk petualangan sinematik yang tak terlupakan, karena kami hadir untuk memandu Anda menemukan film-film terbaik yang layak untuk waktu dan perhatian Anda.',
        'next_blog_id' => 2, // ID post berikutnya untuk navigasi
        'prev_blog_id' => null, // Tidak ada post sebelumnya
    ],
    2 => [
        'title' => 'Tips Memesan Tiket Bioskop Online',
        'date' => '20 Juni 2025',
        'author' => 'Tim BioskopKU',
        'image' => 'assets/img/blog/tips_pesan_tiket_large.jpg', // Path gambar lebih besar untuk detail
        'content' => 'Ingin pengalaman memesan tiket yang mulus dan cepat? Pelajari tips dan trik kami untuk memilih kursi terbaik, memanfaatkan promo, dan menghindari antrean panjang. Proses pemesanan tiket bioskop kini semudah sentuhan jari!. Memesan tiket bioskop secara online telah menjadi standar baru yang menawarkan kemudahan dan efisiensi. Namun, ada beberapa trik yang bisa Anda terapkan untuk memastikan pengalaman pemesanan Anda lebih optimal. Pertama, selalu cek ketersediaan kursi jauh-jauh hari, terutama untuk film-film populer yang baru rilis. Kedua, manfaatkan fitur peta kursi interaktif untuk memilih posisi yang paling nyaman, baik itu di tengah layar atau dekat lorong. Selain itu, jangan lewatkan berbagai promo dan diskon yang sering ditawarkan oleh platform pemesanan tiket atau bioskop itu sendiri. Mengikuti newsletter atau media sosial mereka bisa memberikan Anda akses awal ke penawaran menarik. Terakhir, pastikan koneksi internet Anda stabil saat melakukan transaksi untuk menghindari kegagalan pembayaran. Dengan tips ini, Anda tidak hanya menghemat waktu, tetapi juga mendapatkan pengalaman menonton yang lebih menyenangkan tanpa repot mengantre.',
        'next_blog_id' => null, // Tidak ada post berikutnya
        'prev_blog_id' => 1, // ID post sebelumnya
    ],
    // Tambahkan postingan lain di sini sesuai ID jika diperlukan
];

// Pastikan $blog_id diterima dari controller dan valid
$current_post = null;
if (isset($blog_id) && is_numeric($blog_id) && isset($blog_posts[$blog_id])) {
    $current_post = $blog_posts[$blog_id];
}

if (!$current_post) {
    echo "<p class='message error'>Postingan blog tidak ditemukan.</p>";
    return; // Hentikan eksekusi jika post tidak ditemukan
}
?>

<section id="breadcrumbs" class="breadcrumbs-section">
    <div class="container">
        <ol class="breadcrumb-list">
            <li><a href="index.php?hal=home">Home</a></li>
            <li><a href="index.php?hal=blog">Blog</a></li>
            <li><?= htmlspecialchars($current_post['title']) ?></li>
        </ol>
        <h2 class="section-heading"><?= htmlspecialchars($current_post['title']) ?></h2>
    </div>
</section>

<section id="blog-detail-content" class="blog-detail-content-section">
    <div class="container">
        <div class="blog-post-detail">
            <div class="post-meta">
                <span class="meta-item"><i class="bi bi-calendar-event"></i> <?= htmlspecialchars($current_post['date']) ?></span>
                <span class="meta-item"><i class="bi bi-person-circle"></i> <?= htmlspecialchars($current_post['author']) ?></span>
            </div>

            <?php if ($current_post['image']): ?>
                <div class="post-image-wrapper">
                    <img src="<?= htmlspecialchars($current_post['image']) ?>" alt="<?= htmlspecialchars($current_post['title']) ?>" class="post-main-image img-fluid">
                </div>
            <?php endif; ?>

            <div class="post-content">
                <p><?= nl2br(htmlspecialchars($current_post['content'])) ?></p>
            </div>

            <div class="post-navigation">
                <?php if ($current_post['prev_blog_id']): ?>
                    <a href="index.php?hal=blog_detail&id=<?= $current_post['prev_blog_id'] ?>" class="nav-button nav-prev">
                        <i class="bi bi-arrow-left"></i> Post Sebelumnya
                    </a>
                <?php endif; ?>
                <?php if ($current_post['next_blog_id']): ?>
                    <a href="index.php?hal=blog_detail&id=<?= $current_post['next_blog_id'] ?>" class="nav-button nav-next">
                        Post Berikutnya <i class="bi bi-arrow-right"></i>
                    </a>
                <?php endif; ?>
            </div>
            
            <div class="back-to-blog-list">
                <a href="index.php?hal=blog" class="back-button">
                    <i class="bi bi-arrow-left"></i> Kembali ke Daftar Blog
                </a>
            </div>
        </div>
    </div>
</section>

<style>
    /* Global/Base Styles (Consistent across all views) */
    body {
        font-family: 'Poppins', sans-serif;
        background-color: #f0f2f5;
        color: #333;
        line-height: 1.6;
        margin: 0;
        padding: 0;
    }

    /* Message Styling (Success/Error) - Consistent across views */
    .message {
        padding: 12px 20px;
        margin: 20px auto;
        border-radius: 8px;
        text-align: center;
        font-weight: 600;
        max-width: 900px;
        box-sizing: border-box;
        animation: fadeInDown 0.5s ease-out;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    @keyframes fadeInDown {
        from { opacity: 0; transform: translateY(-20px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .message.error {
        background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb;
    }
    .message.success {
        background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb;
    }

    /* Section Styling (Consistent across all views) */
    section {
        padding: 60px 0;
        overflow: hidden;
        background-color: #ffffff; /* Default background for sections */
        margin-bottom: 30px; /* Space between sections */
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.05);
    }
    section:first-of-type { /* Breadcrumbs */
        margin-top: 20px;
    }
    section:last-of-type { /* Testimonials */
        margin-bottom: 0;
    }
    
    .container {
        max-width: 960px; /* Lebar container utama untuk blog detail */
        margin: 0 auto;
        padding: 0 15px;
    }
    .row {
        display: flex;
        flex-wrap: wrap;
        margin: -15px; /* Kompensasi padding kolom */
    }
    .col-lg-6, .col-md-6, .col-lg-3, .col-12 {
        padding: 15px; /* Spacing internal kolom */
        box-sizing: border-box;
    }
    .d-flex { display: flex; }
    .align-items-stretch { align-items: stretch; }
    .justify-content-center { justify-content: center; }
    .pt-4 { padding-top: 1.5rem; }
    .pt-lg-0 { padding-top: 0; }
    .img-fluid { max-width: 100%; height: auto; }


    /* Breadcrumbs Section (Consistent across views) */
    .breadcrumbs-section {
        background-color: #e9ecef;
        padding: 20px 0;
        border-radius: 8px;
        box-shadow: none;
    }
    .breadcrumb-list {
        display: flex;
        padding: 0;
        margin: 0 0 10px 0;
        list-style: none;
        font-size: 0.9em;
    }
    .breadcrumb-list li {
        color: #6c757d;
    }
    .breadcrumb-list li + li::before {
        content: "/";
        padding: 0 8px;
        color: #adb5bd;
    }
    .breadcrumb-list a {
        color: #007bff;
        text-decoration: none;
        transition: color 0.2s ease;
    }
    .breadcrumb-list a:hover {
        color: #0056b3;
    }
    .breadcrumbs-section .section-heading {
        color: #343a40;
        font-size: 2em;
        font-weight: 700;
        margin: 0;
    }

    /* Blog Detail Content Section */
    .blog-detail-content-section {
        background-color: #f8f9fa;
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.08);
    }
    .blog-post-detail {
        background-color: #ffffff;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        border: 1px solid #eee;
        display: flex;
        flex-direction: column;
        height: 100%;
    }

    .post-meta {
        text-align: center;
        font-size: 0.9em;
        color: #888;
        margin-bottom: 25px;
        padding-bottom: 15px;
        border-bottom: 1px dashed #eee;
    }
    .meta-item {
        display: inline-block;
        margin: 0 10px;
    }
    .meta-item i {
        margin-right: 5px;
        color: #007bff;
    }

    .post-image-wrapper {
        text-align: center;
        margin-bottom: 30px;
    }
    .post-main-image {
        max-width: 100%;
        height: auto;
        border-radius: 12px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        display: block;
        margin: 0 auto;
    }

    .post-content {
        line-height: 1.7;
        font-size: 1.05em;
        color: #555;
        margin-bottom: 30px;
        flex-grow: 1; /* Konten mengisi sisa ruang */
    }
    .post-content p {
        margin-bottom: 1em;
    }

    .post-navigation {
        display: flex;
        justify-content: space-between;
        margin-top: 20px;
        padding-top: 20px;
        border-top: 1px dashed #eee;
    }
    .nav-button {
        background-color: #f0f0f0;
        color: #007bff;
        padding: 10px 15px;
        border-radius: 20px;
        text-decoration: none;
        font-weight: 600;
        font-size: 0.9em;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        transition: background-color 0.2s ease, color 0.2s ease;
        border: 1px solid #ddd;
    }
    .nav-button:hover {
        background-color: #e0e0e0;
        color: #0056b3;
    }
    .nav-button i {
        font-size: 1.1em;
    }

    .back-to-blog-list {
        text-align: center;
        margin-top: 40px;
    }
    .back-button {
        background-color: #6c757d;
        color: white;
        padding: 12px 25px;
        border-radius: 30px;
        text-decoration: none;
        font-weight: 600;
        font-size: 0.95em;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        transition: background-color 0.2s ease, transform 0.2s ease;
        box-shadow: 0 3px 8px rgba(108,117,125,0.2);
    }
    .back-button:hover {
        background-color: #5a6268;
        transform: translateY(-2px);
    }
    .back-button i {
        vertical-align: middle;
    }

    /* Responsive Adjustments */
    @media (max-width: 768px) {
        section {
            padding: 40px 0;
            margin-bottom: 20px;
        }
        .container {
            padding: 0 10px;
        }
        .breadcrumbs-section .section-heading {
            font-size: 1.8em;
        }
        .blog-post-detail {
            padding: 20px;
        }
        .post-meta {
            margin-bottom: 20px;
            padding-bottom: 10px;
        }
        .post-image-wrapper {
            margin-bottom: 20px;
        }
        .post-content {
            font-size: 0.95em;
            margin-bottom: 20px;
        }
        .post-navigation {
            flex-direction: column;
            gap: 15px;
            padding-top: 15px;
            margin-top: 15px;
        }
        .nav-button {
            width: 100%;
            justify-content: center;
            font-size: 0.85em;
        }
        .back-to-blog-list {
            margin-top: 30px;
        }
        .back-button {
            width: 100%;
            justify-content: center;
        }
    }

    @media (max-width: 480px) {
        .breadcrumbs-section .section-heading {
            font-size: 1.5em;
        }
        .post-meta {
            font-size: 0.8em;
        }
        .post-content {
            font-size: 0.9em;
        }
    }
</style>