<?php
// views/forgot_password_request.php

// Pesan sukses atau error dari sesi
if (isset($_SESSION['error_message'])) {
    echo "<p style='color: red; text-align: center; font-weight: bold;'>" . htmlspecialchars($_SESSION['error_message']) . "</p>";
    unset($_SESSION['error_message']);
}
if (isset($_SESSION['success_message'])) {
    echo "<p style='color: green; text-align: center; font-weight: bold;'>" . htmlspecialchars($_SESSION['success_message']) . "</p>";
    unset($_SESSION['success_message']);
}
if (isset($_SESSION['info_message'])) {
    echo "<p style='color: blue; text-align: center; font-weight: bold;'>" . htmlspecialchars($_SESSION['info_message']) . "</p>";
    unset($_SESSION['info_message']);
}
?>

<div style="max-width: 450px; margin: 50px auto; padding: 25px; border: 1px solid #ddd; border-radius: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);">
    <h1 style="text-align: center; color: #333; margin-bottom: 25px;">Lupa Sandi</h1>
    <p style="text-align: center; color: #555; margin-bottom: 30px;">
        Masukkan alamat email yang terdaftar di akun Anda. Kami akan mengirimkan tautan untuk mengatur ulang sandi Anda.
    </p>
    
    <form action="index.php?hal=forgot_password_send_link" method="POST" style="display: flex; flex-direction: column; gap: 20px;">
        <div style="display: flex; flex-direction: column;">
            <label for="email" style="margin-bottom: 8px; font-weight: bold; color: #555;">Email:</label>
            <input type="email" id="email" name="email" required 
                   placeholder="Masukkan email Anda"
                   style="padding: 12px; border: 1px solid #ccc; border-radius: 5px; font-size: 16px;">
        </div>

        <button type="submit" 
                style="padding: 14px 20px; background-color: #007bff; color: white; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; transition: background-color 0.3s ease;">
            Kirim Link Reset
        </button>
        <p style="text-align: center; margin-top: 20px; color: #555;">
            <a href="index.php?hal=login" style="color: #007bff; text-decoration: none; font-weight: bold;">Kembali ke Login</a>
        </p>
    </form>
</div>
