<?php
    //ciptakan object dari class Tiket, Users, dan Detail_Pemesanan
    $obj_tiket = new Tiket();
    $obj_users = new Users();
    $obj_pesan = new Detail_Pemesanan();
    
    //panggil fungsi untuk menampilkan data tiket dan users
    $data_tiket = $obj_tiket->dataTiket();
    $data_users = $obj_users->dataUsers();

    //tangkap request idedit di url (setelah klik tombol edit/icon pencil)
    $idedit = htmlspecialchars($_REQUEST['idedit'] ?? '');
    $pesan = !empty($idedit) ? $obj_pesan->getPemesanan($idedit) : array() ;

    //beri session untuk hak akses halaman member
    $sesi = $_SESSION['USERS'] ?? null;
    if(isset($sesi) && ($sesi['role'] == 'admin' || $sesi['role'] == 'staff')){ // Hanya admin dan staff yang bisa akses
?>

<section class="page-title bg-title overlay-dark">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center">
                <div class="title mt-5">
                    <h3>Update Pemesanan Tiket</h3>
                </div>
                <ol class="breadcrumb justify-content-center p-0 m-0">
                    <li class="breadcrumb-item"><a href="index.php?hal=home">Home</a></li>
                    <li class="breadcrumb-item active">Pemesanan</li>
                    <li class="breadcrumb-item active">Update Pesan Tiket</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="section contact-form">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="section-title">
                    <h3>Update <span class="alternate">Pemesanan Tiket</span></h3>
                </div>
            </div>
        </div>
        <form action="controllers/PemesananController.php" method="POST" class="row">
            <div class="col-md-6 mt-5">
                <label class="form-label fw-bold" for="users_id">Users ID</label>
                <div class="form-group">
                    <select class="form-control main" name="users_id" id="users_id" required>
                    <option value="">-- Pilih User --</option>
                        <?php
                            foreach($data_users as $users){
                            $usr = (isset($pesan['users_id']) && $pesan['users_id'] == $users['id']) ? 'selected' : '';
                        ?>
                        <option value="<?= htmlspecialchars($users['id']) ?>" <?= $usr ?>> <?= htmlspecialchars($users['username']) ?> </option>
                        <?php
                            }
                        ?>
                    </select>
                </div>
            </div>
            <div class="col-md-6 mt-5">
                <label class="form-label fw-bold" for="tiket_id">Tiket ID & Harga</label>
                <div class="form-group">
                    <select class="form-control main" name="tiket_id" id="tiket_id" required>
                    <option value="">-- Pilih Tiket Id & Harga --</option>
                        <?php
                            foreach($data_tiket as $tiket){
                            $tik = (isset($pesan['tiket_id']) && $pesan['tiket_id'] == $tiket['id']) ? 'selected' : '';
                        ?>
                        <option value="<?= htmlspecialchars($tiket['id']) ?>" <?= $tik ?>> Id: <?= htmlspecialchars($tiket['id']) ?> - Harga: Rp.<?= number_format(htmlspecialchars($tiket['harga']), 0, ',', '.') ?> - Film: <?= htmlspecialchars($tiket['judul_film']) ?> - Kursi: <?= htmlspecialchars($tiket['nomor_kursi']) ?> </option>
                        <?php
                            }
                        ?>
                    </select>
                </div>
            </div>
            <div class="col-md-6 mt-5">
                <label class="form-label fw-bold" for="jml_tiket">Jumlah Tiket Beli</label>
                <input type="number" class="form-control main" name="jml_tiket" id="jml_tiket" 
                placeholder="Jumlah Tiket" value="<?= htmlspecialchars($pesan['jml_tiket'] ?? '') ?>" min="1" required>
            </div>
            <div class="col-md-6 mt-5">
                <label class="form-label fw-bold" for="tgl">Tanggal Beli</label>
                <input type="date" class="form-control main" name="tgl" id="tgl" 
                placeholder="Tanggal Beli" value="<?= htmlspecialchars($pesan['tgl'] ?? '') ?>" required>
            </div>
            <div class="col-md-6 mt-5">
                <label class="form-label fw-bold" for="total_harga">Total Harga</label>
                <input type="text" class="form-control main" name="total_harga" id="total_harga"
                placeholder="Total Harga" value="<?= htmlspecialchars($pesan['total_harga'] ?? '') ?>" required>
            </div>
            <div class="col-12 text-center mt-4">
                <button type="submit" name="proses" value="ubah" class="btn btn-success btn-md m-3">Ubah</button>
                <input type="hidden" name="idx" value="<?= htmlspecialchars($idedit) ?>">
                <button type="submit" name="proses" value="batal" class="btn btn-danger btn-md ">Batal</button>
            </div>
        </form>
    </div>
</section>
<?php 
}
else{
    // Jika tidak punya hak akses, arahkan kembali ke halaman login_form.php dengan pesan error
    echo '<script>alert("Anda Dilarang Akses Halaman Ini !!!");';
    echo 'window.location.href="login_form.php";</script>';
    exit(); // Penting untuk menghentikan eksekusi script setelah redirect
}
?>