<?php
// views/jadwal.php
// View ini digunakan untuk menampilkan daftar semua jadwal tayang.
// Variabel yang diharapkan: $jadwal (array asosiatif berisi data jadwal)
// Variabel ini disediakan oleh JadwalController->index()

// Pesan sukses atau error/info dari sesi
if (isset($_SESSION['error_message'])) {
    echo "<p class='message error'>" . htmlspecialchars($_SESSION['error_message']) . "</p>";
    unset($_SESSION['error_message']);
}
if (isset($_SESSION['success_message'])) {
    echo "<p class='message success'>" . htmlspecialchars($_SESSION['success_message']) . "</p>";
    unset($_SESSION['success_message']);
}
if (isset($_SESSION['info_message'])) {
    echo "<p class='message info'>" . htmlspecialchars($_SESSION['info_message']) . "</p>";
    unset($_SESSION['info_message']);
}
?>

<div class="main-content-container">
    <h1 class="page-title">Daftar Jadwal Tayang Bioskop</h1>
    <p class="page-description">Kelola dan lihat semua jadwal film yang tayang di bioskop.</p>

    <div class="action-bar">
        <a href="index.php?hal=jadwal_create" class="add-button">
            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus-circle"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="16"></line><line x1="8" y1="12" x2="16" y2="12"></line></svg>
            Tambah Jadwal Baru
        </a>
        <a href="index.php?hal=jadwal_generate" class="generate-button">
            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-calendar"><rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect><line x1="16" y1="2" x2="16" y2="6"></line><line x1="8" y1="2" x2="8" y2="6"></line><line x1="3" y1="10" x2="21" y2="10"></line></svg>
            Generate Jadwal Mingguan
        </a>
        <button type="button" class="delete-selected-button" id="deleteSelectedButton" style="display: none;">
            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash-2"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg>
            Hapus yang Dipilih (<span id="selectedCount">0</span>)
        </button>
    </div>

    <?php if (!empty($jadwal)): ?>
        <form id="bulkDeleteForm" method="POST" action="index.php?hal=jadwal_bulk_destroy">
            <div class="table-container">
                <table class="styled-table">
                    <thead>
                        <tr>
                            <th class="checkbox-col"><input type="checkbox" id="selectAllCheckboxes"></th>
                            <th>No.</th>
                            <th>Film</th>
                            <th>Studio</th>
                            <th>Tanggal</th>
                            <th>Waktu</th>
                            <th class="text-right">Harga</th>
                            <th class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no = 1; ?>
                        <?php foreach ($jadwal as $j): ?>
                            <tr>
                                <td class="checkbox-col">
                                    <input type="checkbox" name="selected_ids[]" value="<?php echo htmlspecialchars($j['id']); ?>" class="item-checkbox">
                                </td>
                                <td data-label="No."><?php echo $no++; ?></td>
                                <td data-label="Film"><?php echo htmlspecialchars($j['film_judul']); ?></td>
                                <td data-label="Studio"><?php echo htmlspecialchars($j['studio_nama']); ?></td>
                                <td data-label="Tanggal"><?php echo htmlspecialchars($j['tanggal_tayang']); ?></td>
                                <td data-label="Waktu"><?php echo htmlspecialchars(substr($j['waktu_tayang'], 0, 5)); ?></td>
                                <td data-label="Harga" class="text-right">Rp <?php echo number_format($j['harga_tiket'], 0, ',', '.'); ?></td>
                                <td class="action-buttons-cell">
                                    <a href="index.php?hal=jadwal_edit&id=<?php echo htmlspecialchars($j['id']); ?>"
                                       class="action-btn action-btn-edit">
                                        Edit
                                    </a>
                                    <button type="button" class="action-btn action-btn-danger open-delete-modal"
                                            data-id="<?php echo htmlspecialchars($j['id']); ?>"
                                            data-name="Jadwal Film: <?php echo htmlspecialchars($j['film_judul']); ?> (<?= htmlspecialchars($j['tanggal_tayang']) ?> <?= htmlspecialchars(substr($j['waktu_tayang'], 0, 5)) ?>)">
                                        Hapus
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </form>
    <?php else: ?>
        <div class="empty-state">
            <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="#ccc" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-calendar"><rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect><line x1="16" y1="2" x2="16" y2="6"></line><line x1="8" y1="2" x2="8" y2="6"></line><line x1="3" y1="10" x2="21" y2="10"></line></svg>
            <p>Belum ada jadwal tayang yang tersedia.</p>
            <a href="index.php?hal=jadwal_create" class="action-button">Tambah Jadwal Pertama Anda!</a>
        </div>
    <?php endif; ?>
</div>

<div id="deleteConfirmationModal" class="modal">
    <div class="modal-content">
        <span class="close-button">&times;</span>
        <div class="modal-header">
            <i class="bi bi-exclamation-triangle-fill modal-icon"></i>
            <h2>Konfirmasi Hapus Jadwal</h2>
        </div>
        <div class="modal-body">
            <p>Anda yakin ingin menghapus <strong id="itemNameToDelete"></strong>?</p>
            <p>Tindakan ini tidak dapat dibatalkan. Semua pemesanan terkait jadwal ini juga akan dibatalkan.</p>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn-cancel">Batal</button>
            <button type="button" class="btn-confirm-delete">Hapus</button>
        </div>
    </div>
</div>

<div id="bulkDeleteConfirmationModal" class="modal">
    <div class="modal-content">
        <span class="close-button">&times;</span>
        <div class="modal-header">
            <i class="bi bi-exclamation-triangle-fill modal-icon"></i>
            <h2>Konfirmasi Hapus Massal</h2>
        </div>
        <div class="modal-body">
            <p>Anda yakin ingin menghapus <strong id="bulkDeleteItemCount"></strong> jadwal yang dipilih?</p>
            <p>Tindakan ini tidak dapat dibatalkan. Semua pemesanan terkait jadwal-jadwal ini juga akan dibatalkan.</p>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn-cancel-bulk">Batal</button>
            <button type="button" class="btn-confirm-bulk-delete">Hapus</button>
        </div>
    </div>
</div>

<form id="deleteItemForm" method="POST" action="">
    <input type="hidden" name="id" id="deleteItemId">
</form>

<div id="loadingOverlay" class="loading-overlay">
    <div class="spinner"></div>
    <p>Menghapus jadwal, mohon tunggu...</p>
</div>

---

<style>
    /* Global/Base Styles */
    body {
        font-family: 'Poppins', sans-serif;
        background-color: #f0f2f5;
        color: #333;
        line-height: 1.6;
        margin: 0;
        padding: 0;
    }

    /* Message Styling (Success/Error/Info) */
    .message {
        padding: 12px 20px;
        margin: 20px auto;
        border-radius: 8px;
        text-align: center;
        font-weight: 600;
        max-width: 900px;
        box-sizing: border-box;
        animation: fadeInDown 0.5s ease-out;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    @keyframes fadeInDown {
        from { opacity: 0; transform: translateY(-20px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .message.error {
        background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb;
    }
    .message.success {
        background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb;
    }
    .message.info { /* New style for info messages */
        background-color: #d1ecf1; color: #0c5460; border: 1px solid #bee5eb;
    }

    /* Main Container for the Page */
    .main-content-container {
        max-width: 1200px;
        margin: 30px auto;
        padding: 30px;
        background-color: #ffffff;
        border-radius: 12px;
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
        animation: fadeIn 0.8s ease-out;
    }
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .page-title {
        text-align: center;
        color: #1a2a3a;
        font-size: 2.8em;
        font-weight: 800;
        margin-bottom: 10px;
        position: relative;
        padding-bottom: 15px;
    }
    .page-title::after {
        content: '';
        width: 80px;
        height: 4px;
        background-color: #007bff;
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        border-radius: 2px;
    }

    .page-description {
        text-align: center;
        color: #6a737d;
        font-size: 1.1em;
        margin-bottom: 30px;
        line-height: 1.5;
    }

    /* Action Bar (Tambah & Generate Buttons) */
    .action-bar {
        text-align: right;
        margin-bottom: 25px;
        padding-bottom: 15px;
        border-bottom: 1px solid #eee;
        display: flex; /* Use flex to align buttons */
        justify-content: flex-end; /* Align to the right */
        gap: 15px; /* Space between buttons */
        flex-wrap: wrap; /* Wrap buttons on small screens */
    }
    .add-button, .generate-button { /* Reusing add-button style, making new for generate */
        background-color: #4CAF50;
        color: white;
        padding: 10px 20px;
        border-radius: 30px;
        text-decoration: none;
        font-weight: 600;
        font-size: 0.95em;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        transition: background-color 0.2s ease, transform 0.2s ease;
        box-shadow: 0 3px 8px rgba(76,175,80,0.2);
    }
    .add-button:hover, .generate-button:hover {
        background-color: #45a049;
        color: white; /* Keep text white on hover */
        transform: translateY(-2px);
    }
    .add-button svg, .generate-button svg {
        vertical-align: middle;
    }
    .generate-button { /* Specific style for generate button */
        background-color: #6c757d; /* Grey/Secondary color */
        box-shadow: 0 3px 8px rgba(108,117,125,0.2);
    }
    .generate-button:hover {
        background-color: #5a6268;
    }
    /* New: Delete Selected Button */
    .delete-selected-button {
        background-color: #dc3545; /* Merah untuk hapus */
        color: white;
        padding: 10px 20px;
        border-radius: 30px;
        border: none;
        font-weight: 600;
        font-size: 0.95em;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        cursor: pointer;
        transition: background-color 0.2s ease, transform 0.2s ease;
        box-shadow: 0 3px 8px rgba(220,53,69,0.2);
    }
    .delete-selected-button:hover {
        background-color: #c82333;
        transform: translateY(-2px);
    }


    /* Table Styling (from user.php) */
    .table-container {
        overflow-x: auto;
        margin-top: 20px;
        background-color: #fff;
        border-radius: 12px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.08);
        padding: 20px;
    }

    .styled-table {
        width: 100%;
        border-collapse: collapse;
        margin: 0;
        font-size: 0.95em;
    }

    .styled-table th,
    .styled-table td {
        padding: 12px 15px;
        border: 1px solid #e0e0e0;
        text-align: left;
    }

    .styled-table thead tr {
        background-color: #007bff;
        color: white;
        text-align: left;
        font-weight: 600;
    }

    .styled-table tbody tr:nth-of-type(even) {
        background-color: #f6f6f6;
    }

    .styled-table tbody tr:hover {
        background-color: #e9f5ff;
        cursor: pointer;
    }

    .styled-table td.text-right {
        text-align: right;
    }
    .styled-table td.text-center {
        text-align: center;
    }

    .action-buttons-cell {
        display: flex;
        flex-wrap: wrap;
        gap: 8px;
        justify-content: center;
        align-items: center;
    }

    /* Tombol Aksi - Warna Minimalis */
    .action-btn {
        padding: 8px 12px;
        border-radius: 20px;
        text-decoration: none;
        font-weight: 600;
        font-size: 0.85em;
        transition: all 0.2s ease;
        text-align: center;
        white-space: nowrap;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        border: 1px solid transparent;
        display: inline-block;
        cursor: pointer;
    }
    .action-btn-edit {
        background-color: #17a2b8;
        color: white;
        border-color: #17a2b8;
    }
    .action-btn-edit:hover {
        background-color: #138496;
        border-color: #138496;
        color: white;
        transform: translateY(-1px);
    }
    .action-btn-danger {
        background-color: #dc3545;
        color: white;
        border: none;
        cursor: pointer;
    }
    .action-btn-danger:hover {
        background-color: #c82333;
        transform: translateY(-1px);
    }

    /* Checkbox Column Styling */
    .checkbox-col {
        width: 30px; /* Lebar kolom checkbox */
        text-align: center;
    }
    .checkbox-col input[type="checkbox"] {
        transform: scale(1.2); /* Memperbesar checkbox */
        cursor: pointer;
    }

    /* Empty State (from user.php) */
    .empty-state {
        text-align: center;
        padding: 50px 20px;
        background-color: #fefefe;
        border: 1px dashed #e0e0e0;
        border-radius: 10px;
        margin-top: 30px;
        color: #888;
        animation: popIn 0.5s ease-out;
    }
    @keyframes popIn {
        from { opacity: 0; transform: scale(0.9); }
        to { opacity: 1; transform: scale(1); }
    }
    .empty-state svg {
        margin-bottom: 20px;
        color: #ccc;
    }
    .empty-state p {
        font-size: 1.1em;
        margin-bottom: 25px;
    }
    .action-button { /* Re-use style for primary action button */
        background-color: #007bff;
        color: white;
        padding: 12px 25px;
        border-radius: 30px;
        text-decoration: none;
        font-weight: 600;
        transition: background-color 0.3s ease, transform 0.2s ease;
        box-shadow: 0 3px 8px rgba(0, 123, 255, 0.2);
    }
    .action-button:hover {
        background-color: #0056b3;
        color: white;
        transform: translateY(-2px);
    }

    /* DELETE MODAL STYLES (copied from user.php with minor adjustments) */
    .modal {
        display: none; /* Hidden by default */
        position: fixed;
        z-index: 1000;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        overflow: auto;
        background-color: rgba(0,0,0,0.6);
        justify-content: center;
        align-items: center;
        animation: fadeInOverlay 0.3s forwards;
    }
    .modal.show {
        display: flex;
    }
    @keyframes fadeInOverlay {
        from { opacity: 0; }
        to { opacity: 1; }
    }
    .modal-content {
        background-color: #fefefe;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 8px 25px rgba(0,0,0,0.2);
        width: 90%;
        max-width: 500px;
        position: relative;
        animation: popInModal 0.3s forwards;
        transform: scale(0.95);
        opacity: 0;
        display: flex;
        flex-direction: column;
        gap: 20px;
    }
    @keyframes popInModal {
        from { opacity: 0; transform: scale(0.95); }
        to { opacity: 1; transform: scale(1); }
    }
    .close-button {
        color: #aaa; position: absolute; top: 15px; right: 20px;
        font-size: 32px; font-weight: bold; cursor: pointer; transition: color 0.2s ease;
    }
    .close-button:hover, .close-button:focus { color: #333; }
    .modal-header {
        display: flex; align-items: center; gap: 15px; border-bottom: 1px solid #eee;
        padding-bottom: 15px; margin-bottom: 20px;
    }
    .modal-icon { color: #ffc107; font-size: 2.5em; flex-shrink: 0; }
    .modal-header h2 { margin: 0; color: #333; font-size: 1.8em; font-weight: 700; line-height: 1.2; }
    .modal-body { font-size: 1.05em; line-height: 1.6; color: #555; }
    .modal-body strong { color: #1a2a3a; }
    .modal-footer {
        display: flex; justify-content: flex-end; gap: 10px; padding-top: 20px;
        border-top: 1px solid #eee; margin-top: 20px;
    }
    .btn-cancel, .btn-confirm-delete, .btn-cancel-bulk, .btn-confirm-bulk-delete {
        padding: 12px 25px; border-radius: 8px; font-size: 1em; font-weight: 600;
        cursor: pointer; transition: all 0.2s ease; border: none;
    }
    .btn-cancel, .btn-cancel-bulk { background-color: #6c757d; color: white; }
    .btn-cancel:hover, .btn-cancel-bulk:hover { background-color: #5a6268; transform: translateY(-1px); }
    .btn-confirm-delete, .btn-confirm-bulk-delete { background-color: #dc3545; color: white; }
    .btn-confirm-delete:hover, .btn-confirm-bulk-delete:hover { background-color: #c82333; transform: translateY(-1px); }

    /* LOADING OVERLAY STYLES (copied from user.php) */
    .loading-overlay {
        display: none; /* Hidden by default */
        position: fixed;
        top: 0; left: 0; width: 100%; height: 100%;
        background-color: rgba(255, 255, 255, 0.8);
        z-index: 1001;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        backdrop-filter: blur(5px);
        animation: fadeInLoading 0.3s forwards;
    }
    .loading-overlay.show {
        display: flex;
    }
    @keyframes fadeInLoading { from { opacity: 0; } to { opacity: 1; } }
    .spinner {
        border: 8px solid #f3f3f3; border-top: 8px solid #007bff; border-radius: 50%;
        width: 60px; height: 60px; animation: spin 1s linear infinite; margin-bottom: 20px;
    }
    @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
    .loading-overlay p { color: #333; font-size: 1.2em; font-weight: 600; margin: 0; }


    /* Responsive Adjustments */
    @media (max-width: 992px) {
        .main-content-container { max-width: 90%; }
        .action-bar { justify-content: center; gap: 10px; }
        .add-button, .generate-button, .delete-selected-button { padding: 8px 15px; font-size: 0.9em; flex-grow: 1; text-align: center; }
        .styled-table th, .styled-table td { padding: 10px 12px; font-size: 0.9em; }
        .action-buttons-cell { flex-direction: column; align-items: stretch; }
        .action-btn { width: 100%; min-width: unset; margin-bottom: 5px; }
        .modal-content { padding: 20px; }
        .modal-header h2 { font-size: 1.5em; }
        .modal-icon { font-size: 2em; }
        .modal-body { font-size: 0.95em; }
        .btn-cancel, .btn-confirm-delete, .btn-cancel-bulk, .btn-confirm-bulk-delete { padding: 10px 20px; font-size: 0.9em; }
        .spinner { width: 50px; height: 50px; }
        .loading-overlay p { font-size: 1.1em; }
    }
    @media (max-width: 768px) {
        .main-content-container { margin: 20px 15px; padding: 20px; }
        .page-title { font-size: 2.2em; }
        .page-description { font-size: 1em; }
        .action-bar { text-align: center; flex-direction: column; align-items: center; }
        .add-button, .generate-button, .delete-selected-button { width: 100%; box-sizing: border-box; justify-content: center; }
        .styled-table, .table-container { border-radius: 8px; }
        .styled-table thead { display: none; }
        .styled-table, .styled-table tbody, .styled-table tr, .styled-table td { display: block; width: 100%; }
        .styled-table tr {
            margin-bottom: 15px; border: 1px solid #e0e0e0; border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05); padding: 10px; background-color: #fff;
        }
        .styled-table td {
            text-align: right !important; padding-left: 50% !important; position: relative; border: none;
        }
        .styled-table td::before {
            content: attr(data-label); position: absolute; left: 10px;
            width: calc(50% - 20px); padding-right: 10px; white-space: nowrap;
            text-align: left; font-weight: 600; color: #555;
        }
        /* Specific data-labels for jadwal table */
        .styled-table td:first-child::before { content: "Pilih:"; } /* For checkbox column */
        .styled-table td:nth-child(2)::before { content: "No."; }
        .styled-table td:nth-child(3)::before { content: "Film:"; }
        .styled-table td:nth-child(4)::before { content: "Studio:"; }
        .styled-table td:nth-child(5)::before { content: "Tanggal:"; }
        .styled-table td:nth-child(6)::before { content: "Waktu:"; }
        .styled-table td:nth-child(7)::before { content: "Harga:"; }
        .styled-table td:last-child::before { content: "Aksi:"; }

        .action-buttons-cell { justify-content: flex-end; padding-left: 0 !important; }
    }
    @media (max-width: 480px) {
        .page-title { font-size: 2em; }
        .action-btn { font-size: 0.8em; padding: 7px 10px; }
        .modal-header h2 { font-size: 1.3em; }
        .modal-icon { font-size: 1.8em; }
        .modal-body { font-size: 0.9em; }
        .btn-cancel, .btn-confirm-delete, .btn-cancel-bulk, .btn-confirm-bulk-delete { padding: 8px 15px; font-size: 0.8em; }
        .spinner { width: 40px; height: 40px; }
        .loading-overlay p { font-size: 1em; }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // --- Modal Delete Logic (Single Item) ---
        const deleteConfirmationModal = document.getElementById('deleteConfirmationModal');
        const closeButton = deleteConfirmationModal.querySelector('.close-button');
        const cancelButton = deleteConfirmationModal.querySelector('.btn-cancel');
        const confirmDeleteButton = deleteConfirmationModal.querySelector('.btn-confirm-delete');
        const openDeleteButtons = document.querySelectorAll('.open-delete-modal'); // For all single delete buttons
        const deleteItemForm = document.getElementById('deleteItemForm');
        const deleteItemIdInput = document.getElementById('deleteItemId');
        const itemNameToDeleteSpan = document.getElementById('itemNameToDelete');
        const loadingOverlay = document.getElementById('loadingOverlay');

        let itemIdToDelete = null; // Used for single delete

        openDeleteButtons.forEach(button => {
            button.addEventListener('click', function() {
                itemIdToDelete = this.dataset.id;
                const itemName = this.dataset.name;
                itemNameToDeleteSpan.textContent = itemName;
                deleteConfirmationModal.classList.add('show');
            });
        });

        function closeModal(modalElement) {
            modalElement.classList.remove('show');
            // Reset state for single delete modal
            if (modalElement === deleteConfirmationModal) {
                itemIdToDelete = null;
                itemNameToDeleteSpan.textContent = '';
            }
            // No reset needed for bulk modal here, handled by form submit
        }

        closeButton.addEventListener('click', () => closeModal(deleteConfirmationModal));
        cancelButton.addEventListener('click', () => closeModal(deleteConfirmationModal));

        window.addEventListener('click', function(event) {
            if (event.target == deleteConfirmationModal) {
                closeModal(deleteConfirmationModal);
            } else if (event.target == bulkDeleteConfirmationModal) { // Handle bulk modal close
                closeModal(bulkDeleteConfirmationModal);
            }
        });

        confirmDeleteButton.addEventListener('click', function() {
            if (itemIdToDelete) {
                loadingOverlay.classList.add('show');
                deleteItemIdInput.value = itemIdToDelete;
                deleteItemForm.action = `index.php?hal=jadwal_destroy&id=${itemIdToDelete}`;
                deleteItemForm.submit();
            }
        });

        // Optional: Hide loading overlay if page load fails or if there's a back navigation
        window.addEventListener('pageshow', function(event) {
            if (event.persisted) {
                loadingOverlay.classList.remove('show');
            }
        });
        // --- END Modal Delete Logic (Single Item) ---

        // --- Bulk Delete Logic ---
        const selectAllCheckbox = document.getElementById('selectAllCheckboxes');
        const itemCheckboxes = document.querySelectorAll('.item-checkbox');
        const deleteSelectedButton = document.getElementById('deleteSelectedButton');
        const selectedCountSpan = document.getElementById('selectedCount');
        const bulkDeleteForm = document.getElementById('bulkDeleteForm');

        // Modal elements for bulk delete
        const bulkDeleteConfirmationModal = document.getElementById('bulkDeleteConfirmationModal');
        const closeBulkButton = bulkDeleteConfirmationModal.querySelector('.close-button');
        const cancelBulkButton = bulkDeleteConfirmationModal.querySelector('.btn-cancel-bulk');
        const confirmBulkDeleteButton = bulkDeleteConfirmationModal.querySelector('.btn-confirm-bulk-delete');
        const bulkDeleteItemCountSpan = document.getElementById('bulkDeleteItemCount');

        function updateSelectedCount() {
            let selectedCount = 0;
            itemCheckboxes.forEach(checkbox => {
                if (checkbox.checked) {
                    selectedCount++;
                }
            });

            selectedCountSpan.textContent = selectedCount;
            if (selectedCount > 0) {
                deleteSelectedButton.style.display = 'inline-flex';
            } else {
                deleteSelectedButton.style.display = 'none';
            }

            // Update "Select All" checkbox state
            if (selectedCount === itemCheckboxes.length && itemCheckboxes.length > 0) {
                selectAllCheckbox.checked = true;
            } else if (selectedCount === 0) {
                selectAllCheckbox.checked = false;
            } else {
                selectAllCheckbox.indeterminate = true; // Some are checked, but not all
            }
        }

        selectAllCheckbox.addEventListener('change', function() {
            itemCheckboxes.forEach(checkbox => {
                checkbox.checked = this.checked;
            });
            updateSelectedCount();
        });

        itemCheckboxes.forEach(checkbox => {
            checkbox.addEventListener('change', updateSelectedCount);
        });

        // Event listener for the "Hapus yang Dipilih" button
        deleteSelectedButton.addEventListener('click', function() {
            const selectedIds = Array.from(itemCheckboxes)
                                   .filter(cb => cb.checked)
                                   .map(cb => cb.value);

            if (selectedIds.length > 0) {
                bulkDeleteItemCountSpan.textContent = `${selectedIds.length}`;
                bulkDeleteConfirmationModal.classList.add('show');
            } else {
                alert('Pilih setidaknya satu jadwal untuk dihapus.');
            }
        });

        // Bulk delete modal close logic
        closeBulkButton.addEventListener('click', () => closeModal(bulkDeleteConfirmationModal));
        cancelBulkButton.addEventListener('click', () => closeModal(bulkDeleteConfirmationModal));

        // Confirm bulk delete
        confirmBulkDeleteButton.addEventListener('click', function() {
            loadingOverlay.classList.add('show');
            bulkDeleteForm.submit(); // Submit the form with selected_ids
        });

        // Initial count update on page load
        updateSelectedCount();
        // --- END Bulk Delete Logic ---
    });
</script>