<?php
// views/jadwal_form.php
// View ini digunakan untuk menampilkan formulir penambahan jadwal baru.
// Variabel yang diharapkan: $films (array asosiatif berisi data film)
// Variabel ini disediakan oleh JadwalController->create()

// Pesan sukses atau error dari sesi
if (isset($_SESSION['error_message'])) {
    echo "<p style='color: red; text-align: center; font-weight: bold;'>" . htmlspecialchars($_SESSION['error_message']) . "</p>";
    unset($_SESSION['error_message']);
}
if (isset($_SESSION['success_message'])) {
    echo "<p style='color: green; text-align: center; font-weight: bold;'>" . htmlspecialchars($_SESSION['success_message']) . "</p>";
    unset($_SESSION['success_message']);
}
?>

<div style="max-width: 600px; margin: 20px auto; padding: 20px; border: 1px solid #ddd; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
    <h1 style="text-align: center; color: #333;">Tambah Jadwal Tayang Baru</h1>
    
    <form action="/BIOSKOP/jadwal/store" method="POST" style="display: flex; flex-direction: column; gap: 15px;">
        <div style="display: flex; flex-direction: column;">
            <label for="film_id" style="margin-bottom: 5px; font-weight: bold;">Pilih Film:</label>
            <select id="film_id" name="film_id" required 
                    style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; font-size: 16px;">
                <option value="">-- Pilih Film --</option>
                <?php
                if (!empty($films)) {
                    foreach ($films as $film) {
                        echo "<option value='" . htmlspecialchars($film['id']) . "'>" . htmlspecialchars($film['judul']) . " (Studio: " . htmlspecialchars($film['studio_nama']) . ")</option>";
                    }
                }
                ?>
            </select>
            <small style="margin-top: 5px; color: #666;">Setiap film terikat pada satu studio.</small>
        </div>

        <div style="display: flex; flex-direction: column;">
            <label for="tanggal_tayang" style="margin-bottom: 5px; font-weight: bold;">Tanggal Tayang:</label>
            <input type="date" id="tanggal_tayang" name="tanggal_tayang" required 
                   min="<?php echo date('Y-m-d'); ?>" 
                   style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; font-size: 16px;">
        </div>

        <div style="display: flex; flex-direction: column;">
            <label for="waktu_tayang" style="margin-bottom: 5px; font-weight: bold;">Waktu Tayang:</label>
            <input type="time" id="waktu_tayang" name="waktu_tayang" required 
                   step="1"  -- Allows seconds input, though you might only need "HH:MM"
                   style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; font-size: 16px;">
            <small style="margin-top: 5px; color: #666;">Format: HH:MM (misal: 09:00, 15:30).</small>
        </div>

        <div style="display: flex; flex-direction: column;">
            <label for="harga_tiket" style="margin-bottom: 5px; font-weight: bold;">Harga Tiket:</label>
            <input type="number" id="harga_tiket" name="harga_tiket" required 
                   min="0" step="1000" placeholder="Contoh: 35000"
                   style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; font-size: 16px;">
            <small style="margin-top: 5px; color: #666;">Masukkan harga dalam Rupiah, tanpa titik atau koma.</small>
        </div>

        <button type="submit" 
                style="padding: 12px 20px; background-color: #007bff; color: white; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; transition: background-color 0.3s ease;">
            Tambah Jadwal
        </button>
    </form>
</div>
