<?php
//ciptakan object dari class Kategori
$model = new Kategori();
//panggil fungsi untuk menampilkan data kategori
$data_kategori = $model->dataKategori(); 

// Mengambil sesi user yang sedang login
$sesi = $_SESSION['USERS'] ?? null; // Pastikan sesi ada, jika tidak set null

//beri session untuk hak akses halaman member
if(isset($sesi)){ // Memastikan user sudah login
?>

    <section id="breadcrumbs" class="breadcrumbs">
      <div class="container">
        <ol>
          <li><a href="index.php?hal=home">Home</a></li>
          <li>Data Bioskop</li>
          <li>Data Kategori</li>
        </ol>
        <h2>Daftar Kategori Film</h2>
      </div>
    </section><section id="services" class="services">
      <div class="container">
      <div class="icontambah mb-4" style="margin-left: 50px;">
            <?php
                // Hanya admin dan staff yang bisa menambah kategori
                if(isset($sesi['role']) && ($sesi['role'] == 'admin' || $sesi['role'] == 'staff')){ 
            ?>
                <a class="btn btn-primary btn-sm" href="index.php?hal=kategori_form" role="button"
                    title="Tambah Kategori">
                    <i class="fa fa-plus" aria-hidden="true"> <label class="p-2">Tambah Kategori</label> </i> 
                </a>
            <?php } ?>
            </div>
        <div class="row">
          <?php
          if (!empty($data_kategori)) { // Cek apakah ada data kategori
              foreach($data_kategori as $row){
          ?>
          <div class="col-lg-4 col-md-6 d-flex align-items-stretch mt-4">
            <div class="icon-box">
              <div class="icon"><i class="bx bx-file"></i></div>
              <h4><a href=""><?= htmlspecialchars($row['kategori']) ?></a></h4>
              <p>ID Kategori: <?= htmlspecialchars($row['id']) ?></p>
              <?php
              // Hanya admin yang bisa mengubah atau menghapus
              if(isset($sesi['role']) && $sesi['role'] == 'admin'){ 
              ?>
              <div class="d-flex justify-content-center mt-3">
                <form action="controllers/KategoriController.php" method="POST">
                  <a href="index.php?hal=kategori_form_update&idedit=<?= htmlspecialchars($row['id']) ?>">
                    <button type="button" class="btn btn-warning btn-sm" title="Ubah Kategori">
                      <i class="fa fa-pencil-square-o" aria-hidden="true"></i>
                    </button>
                  </a>
                  <button type="submit" class="btn btn-danger btn-sm" name="proses" value="hapus"
                    onclick="return confirm('Anda Yakin Data Kategori <?= htmlspecialchars($row['kategori']) ?> Akan di Hapus?')" title="Hapus Kategori">
                    <i class="fa fa-trash-o" aria-hidden="true"></i>
                  </button>
                  <input type="hidden" name="idx" value="<?= htmlspecialchars($row['id']) ?>">
                </form>
              </div>
              <?php } ?>
            </div>
          </div>
          <?php
              }
          } else {
              echo '<div class="col-12"><div class="alert alert-info text-center mt-5">Belum ada data kategori tersedia.</div></div>';
          }
          ?>
        </div>
      </div>
    </section><?php 
}
else{
    // Jika belum login, arahkan kembali ke halaman login_form.php dengan pesan error
    echo '<script>alert("Anda Harus Login Dahulu !!!");';
    echo 'window.location.href="login_form.php";</script>';
    exit(); // Penting untuk menghentikan eksekusi script setelah redirect
}
?>