<?php
// views/kursi.php
// View ini digunakan untuk menampilkan daftar semua kursi.
// Variabel yang diharapkan: $kursis (array asosiatif berisi data kursi)
// Variabel ini disediakan oleh KursiController->index()

// Pesan sukses atau error dari sesi
if (isset($_SESSION['error_message'])) {
    echo "<p class='message error'>" . htmlspecialchars($_SESSION['error_message']) . "</p>";
    unset($_SESSION['error_message']);
}
if (isset($_SESSION['success_message'])) {
    echo "<p class='message success'>" . htmlspecialchars($_SESSION['success_message']) . "</p>";
    unset($_SESSION['success_message']);
}

// Untuk memisahkan kursi berdasarkan studio
$kursis_by_studio = [];
if (!empty($kursis)) {
    foreach ($kursis as $kursi) {
        $studio_id = $kursi['studio_id'];
        $studio_nama = htmlspecialchars($kursi['studio_nama']);
        if (!isset($kursis_by_studio[$studio_id])) {
            $kursis_by_studio[$studio_id] = [
                'name' => $studio_nama,
                'seats' => []
            ];
        }
        $kursis_by_studio[$studio_id]['seats'][] = $kursi;
    }
}
?>

<div class="film-list-container"> <h1 class="page-title">Daftar Kursi Bioskop</h1>
    <p class="page-description">Kelola dan lihat tata letak kursi untuk setiap studio.</p>

    <div class="action-bar">
        <a href="index.php?hal=kursi_create" class="add-film-button">
            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus-circle"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="16"></line><line x1="8" y1="12" x2="16" y2="12"></line></svg>
            Tambah Kursi Baru
        </a>
    </div>

    <?php if (!empty($kursis_by_studio)): ?>
        <?php foreach ($kursis_by_studio as $studio_id => $studio_data): ?>
            <div class="studio-section">
                <h2 class="studio-title"><?= $studio_data['name'] ?></h2>
                <div class="seat-layout-container">
                    <div class="screen-indicator">LAYAR</div>
                    <div class="seat-grid">
                        <?php
                        // Urutkan kursi berdasarkan nomor untuk tampilan yang lebih rapi
                        usort($studio_data['seats'], function($a, $b) {
                            return strnatcmp($a['nomor'], $b['nomor']);
                        });

                        foreach ($studio_data['seats'] as $kursi):
                        ?>
                            <div class="seat-item">
                                <div class="seat-number"><?= htmlspecialchars($kursi['nomor']) ?></div>
                                <div class="seat-actions">
                                    <a href="index.php?hal=kursi_edit&id=<?= htmlspecialchars($kursi['id']) ?>" class="action-btn-mini action-btn-edit">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path><path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path></svg>
                                    </a>
                                    <form action="index.php?hal=kursi_destroy&id=<?= htmlspecialchars($kursi['id']) ?>" method="POST" class="delete-form" onsubmit="return confirm('Apakah Anda yakin ingin menghapus kursi <?= htmlspecialchars($kursi['nomor']) ?> di studio <?= htmlspecialchars($studio_data['name']) ?>?');">
                                        <button type="submit" class="action-btn-mini action-btn-danger">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <div class="empty-state">
            <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24" fill="none" stroke="#ccc" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trello"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect><rect x="7" y="7" width="3" height="9"></rect><rect x="14" y="7" width="3" height="5"></rect></svg>
            <p>Belum ada kursi yang terdaftar.</p>
            <a href="index.php?hal=kursi_create" class="action-button">Tambah Kursi Pertama Anda!</a>
        </div>
    <?php endif; ?>
</div>

<style>
    /* Global/Base Styles (dari file sebelumnya) */
    body {
        font-family: 'Poppins', sans-serif;
        background-color: #f0f2f5;
        color: #333;
        line-height: 1.6;
        margin: 0;
        padding: 0;
    }

    /* Message Styling (Success/Error) */
    .message {
        padding: 12px 20px;
        margin: 20px auto;
        border-radius: 8px;
        text-align: center;
        font-weight: 600;
        max-width: 900px;
        box-sizing: border-box;
        animation: fadeInDown 0.5s ease-out;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    @keyframes fadeInDown {
        from { opacity: 0; transform: translateY(-20px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .message.error {
        background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb;
    }
    .message.success {
        background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb;
    }

    /* Main Container for the Page */
    .film-list-container { /* Menggunakan nama yang sama untuk konsistensi */
        max-width: 1200px;
        margin: 30px auto;
        padding: 30px;
        background-color: #ffffff;
        border-radius: 12px;
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
        animation: fadeIn 0.8s ease-out;
    }
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .page-title {
        text-align: center;
        color: #1a2a3a;
        font-size: 2.8em;
        font-weight: 800;
        margin-bottom: 10px;
        position: relative;
        padding-bottom: 15px;
    }
    .page-title::after {
        content: '';
        width: 80px;
        height: 4px;
        background-color: #007bff;
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        border-radius: 2px;
    }

    .page-description {
        text-align: center;
        color: #6a737d;
        font-size: 1.1em;
        margin-bottom: 30px;
        line-height: 1.5;
    }

    /* Action Bar (Tambah Film Baru) - Re-used for Tambah Kursi */
    .action-bar {
        text-align: right;
        margin-bottom: 25px;
        padding-bottom: 15px;
        border-bottom: 1px solid #eee;
    }
    .add-film-button { /* Re-used for Tambah Kursi Baru */
        background-color: #4CAF50; /* Green (similar to default success) */
        color: white;
        padding: 10px 20px;
        border-radius: 30px;
        text-decoration: none;
        font-weight: 600;
        font-size: 0.95em;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        transition: background-color 0.2s ease, transform 0.2s ease;
        box-shadow: 0 3px 8px rgba(76,175,80,0.2);
    }
    .add-film-button:hover {
        background-color: #45a049;
        transform: translateY(-2px);
    }
    .add-film-button svg {
        vertical-align: middle;
    }

    /* --- Styling Kursi Bioskop --- */
    .studio-section {
        background-color: #fefefe;
        border: 1px solid #e0e0e0;
        border-radius: 10px;
        padding: 25px;
        margin-bottom: 30px;
        box-shadow: 0 3px 10px rgba(0,0,0,0.05);
        animation: fadeIn 0.8s ease-out;
    }

    .studio-title {
        font-size: 2em;
        color: #1a2a3a;
        font-weight: 700;
        margin-top: 0;
        margin-bottom: 25px;
        text-align: center;
        position: relative;
    }
    .studio-title::after {
        content: '';
        width: 60px;
        height: 3px;
        background-color: #007bff;
        position: absolute;
        bottom: -10px;
        left: 50%;
        transform: translateX(-50%);
        border-radius: 2px;
    }

    .seat-layout-container {
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 20px;
    }

    .screen-indicator {
        background-color: #333;
        color: white;
        padding: 15px 30px;
        border-radius: 8px;
        font-weight: 700;
        font-size: 1.2em;
        width: 80%; /* Lebar layar */
        max-width: 600px; /* Batasi lebar layar juga */
        text-align: center;
        box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        margin-bottom: 20px;
    }

    .seat-grid {
        display: grid;
        grid-template-columns: repeat(5, 1fr); /* Tetap 5 kolom */
        gap: 20px; /* Perbesar gap */
        width: 100%;
        max-width: 550px; /* SESUAIKAN MAX-WIDTH UNTUK 5 KOTAK LEBIH BESAR */
        justify-content: center;
        margin-top: 20px;
        padding: 15px; /* Perbesar padding kotak grid */
        border: 2px dashed #e0e0e0;
        border-radius: 10px;
        background-color: #f9f9f9;
        box-sizing: content-box;
    }

    .seat-item {
        background-color: #ffffff;
        border: 1px solid #cceeff;
        border-radius: 8px;
        padding: 15px 10px; /* Perbesar padding vertikal dan horizontal */
        text-align: center;
        font-weight: 600;
        color: #007bff;
        position: relative;
        height: 80px; /* Perbesar tinggi kursi */
        width: 80px; /* Tambahkan lebar eksplisit untuk kotak kursi */
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        align-items: center;
        transition: all 0.2s ease;
        box-shadow: 0 2px 5px rgba(0,0,0,0.08);
        box-sizing: border-box; /* Penting untuk padding dan width */
    }
    .seat-item:hover {
        transform: translateY(-3px) scale(1.05);
        box-shadow: 0 5px 15px rgba(0,0,0,0.15);
        background-color: #FFFFFF;
    }

    .seat-number {
        font-size: 1.2em; /* Perbesar ukuran font nomor kursi */
        margin-bottom: 5px;
    }

    .seat-actions {
        display: flex;
        gap: 5px;
        opacity: 0; /* Sembunyikan aksi secara default */
        transition: opacity 0.2s ease;
    }
    .seat-item:hover .seat-actions {
        opacity: 1; /* Tampilkan aksi saat hover */
    }

    .action-btn-mini {
        padding: 5px 8px;
        border-radius: 5px;
        text-decoration: none;
        font-weight: 500;
        font-size: 0.8em;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        transition: all 0.2s ease;
        line-height: 1; /* Penting untuk SVG di tengah */
    }
    .action-btn-mini svg {
        vertical-align: middle;
    }

    /* Re-use action button styles from film.php, adjusted for mini */
    .action-btn-edit {
        background-color: #17a2b8;
        color: white;
    }
    .action-btn-edit:hover {
        background-color: #138496;
        color: white;
        transform: scale(1.1);
    }
    .action-btn-danger {
        background-color: #dc3545;
        color: white;
        border: none;
        cursor: pointer;
    }
    .action-btn-danger:hover {
        background-color: #c82333;
        color: white;
        transform: scale(1.1);
    }
    .delete-form {
        display: inline-block;
        margin: 0;
        padding: 0;
    }

    /* Empty State (Consistent with other views) */
    .empty-state {
        text-align: center;
        padding: 50px 20px;
        background-color: #fefefe;
        border: 1px dashed #e0e0e0;
        border-radius: 10px;
        margin-top: 30px;
        color: #888;
        animation: popIn 0.5s ease-out;
    }
    @keyframes popIn {
        from { opacity: 0; transform: scale(0.9); }
        to { opacity: 1; transform: scale(1); }
    }
    .empty-state svg {
        margin-bottom: 20px;
        color: #ccc;
    }
    .empty-state p {
        font-size: 1.1em;
        margin-bottom: 25px;
    }
    .action-button { /* Re-use style for primary action button */
        background-color: #007bff;
        color: white;
        padding: 12px 25px;
        border-radius: 30px;
        text-decoration: none;
        font-weight: 600;
        transition: background-color 0.3s ease, transform 0.2s ease;
        box-shadow: 0 3px 8px rgba(0, 123, 255, 0.2);
    }
    .action-button:hover {
        background-color: #0056b3;
        transform: translateY(-2px);
    }

    /* Responsive Adjustments */
    @media (max-width: 992px) {
        .film-list-container {
            max-width: 95%;
        }
        .seat-grid {
            grid-template-columns: repeat(4, 1fr); /* 4 kolom */
            max-width: 480px; /* Sesuaikan max-width untuk 4 kotak lebih besar */
            gap: 15px;
        }
        .seat-item {
            height: 70px; /* Sesuaikan tinggi */
            width: 70px; /* Sesuaikan lebar */
            padding: 12px 8px;
        }
        .seat-number {
            font-size: 1.1em;
        }
    }
    @media (max-width: 768px) {
        .film-list-container {
            margin: 20px 15px;
            padding: 20px;
        }
        .page-title {
            font-size: 2.2em;
        }
        .page-description {
            font-size: 1em;
        }
        .action-bar {
            text-align: center;
        }
        .add-film-button {
            width: 100%;
            box-sizing: border-box;
            justify-content: center;
        }
        .studio-title {
            font-size: 1.8em;
        }
        .screen-indicator {
            padding: 12px 25px;
            font-size: 1.1em;
        }
        .seat-grid {
            grid-template-columns: repeat(3, 1fr); /* 3 kolom */
            max-width: 360px; /* Sesuaikan max-width untuk 3 kotak lebih besar */
            gap: 10px;
            padding: 10px;
        }
        .seat-item {
            height: 60px; /* Sesuaikan tinggi */
            width: 60px; /* Sesuaikan lebar */
            padding: 10px 6px;
            font-size: 0.9em;
        }
        .action-btn-mini {
            padding: 3px 6px;
            font-size: 0.7em;
            width: 25px; /* Fixed size for mini buttons */
            height: 25px;
        }
    }
    @media (max-width: 480px) {
        .page-title {
            font-size: 2em;
        }
        .studio-title {
            font-size: 1.6em;
        }
        .screen-indicator {
            padding: 10px 20px;
            font-size: 1em;
            width: 90%;
        }
        .seat-grid {
            grid-template-columns: repeat(2, 1fr); /* 2 kolom */
            max-width: 260px; /* Sesuaikan max-width untuk 2 kotak lebih besar */
            gap: 8px;
        }
        .seat-item {
            height: 50px; /* Sesuaikan tinggi */
            width: 50px; /* Sesuaikan lebar */
            padding: 8px 5px;
        }
        .seat-number {
            font-size: 0.8em;
        }
        .seat-actions {
            flex-direction: column;
            gap: 3px;
        }
    }
</style>