<?php
// views/register.php
// View ini digunakan untuk menampilkan formulir pendaftaran pengguna baru.

// Pesan sukses atau error dari sesi
if (isset($_SESSION['error_message'])) {
    echo "<p style='color: red; text-align: center; font-weight: bold;'>" . htmlspecialchars($_SESSION['error_message']) . "</p>";
    unset($_SESSION['error_message']);
}
if (isset($_SESSION['success_message'])) {
    echo "<p style='color: green; text-align: center; font-weight: bold;'>" . htmlspecialchars($_SESSION['success_message']) . "</p>";
    unset($_SESSION['success_message']);
}
?>

<div style="max-width: 500px; margin: 20px auto; padding: 20px; border: 1px solid #ddd; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
    <h1 style="text-align: center; color: #333;">Daftar Akun Baru</h1>
    
    <form action="index.php?hal=register_store" method="POST" style="display: flex; flex-direction: column; gap: 15px;">
        <div style="display: flex; flex-direction: column;">
            <label for="fullname" style="margin-bottom: 5px; font-weight: bold;">Nama Lengkap:</label>
            <input type="text" id="fullname" name="fullname" required 
                   placeholder="Masukkan nama lengkap Anda"
                   style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; font-size: 16px;">
        </div>

        <div style="display: flex; flex-direction: column;">
            <label for="jenis_kelamin" style="margin-bottom: 5px; font-weight: bold;">Jenis Kelamin:</label>
            <select id="jenis_kelamin" name="jenis_kelamin" required 
                    style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; font-size: 16px;">
                <option value="">-- Pilih --</option>
                <option value="L">Laki-laki</option>
                <option value="P">Perempuan</option>
            </select>
        </div>

        <div style="display: flex; flex-direction: column;">
            <label for="email" style="margin-bottom: 5px; font-weight: bold;">Email:</label>
            <input type="email" id="email" name="email" required 
                   placeholder="contoh@domain.com"
                   style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; font-size: 16px;">
        </div>

        <div style="display: flex; flex-direction: column;">
            <label for="username" style="margin-bottom: 5px; font-weight: bold;">Username:</label>
            <input type="text" id="username" name="username" required 
                   placeholder="Buat username unik"
                   style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; font-size: 16px;">
        </div>

        <div style="display: flex; flex-direction: column;">
            <label for="password" style="margin-bottom: 5px; font-weight: bold;">Password:</label>
            <input type="password" id="password" name="password" required 
                   placeholder="Masukkan password Anda"
                   style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; font-size: 16px;">
        </div>

        <div style="display: flex; flex-direction: column;">
            <label for="password_confirm" style="margin-bottom: 5px; font-weight: bold;">Konfirmasi Password:</label>
            <input type="password" id="password_confirm" name="password_confirm" required 
                   placeholder="Ulangi password Anda"
                   style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; font-size: 16px;">
        </div>

        <div style="display: flex; flex-direction: column;">
            <label for="no_hp" style="margin-bottom: 5px; font-weight: bold;">Nomor HP (Opsional):</label>
            <input type="tel" id="no_hp" name="no_hp" 
                   placeholder="Contoh: 081234567890"
                   style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; font-size: 16px;">
        </div>

        <button type="submit" 
                style="padding: 12px 20px; background-color: #007bff; color: white; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; transition: background-color 0.3s ease;">
            Daftar
        </button>
        <p style="text-align: center; margin-top: 15px; color: #555;">
            Sudah punya akun? <a href="index.php?hal=login" style="color: #007bff; text-decoration: none;">Login di sini</a>
        </p>
    </form>
</div>
