<?php
    //ciptakan object dari class Tiket, Film, dan Kursi
    $obj_tiket = new Tiket(); // Objek tiket sebenarnya tidak perlu di sini untuk form input baru
    $obj_film = new Film();
    $obj_kursi = new Kursi();
    
    //panggil fungsi untuk menampilkan data film dan kursi
    $data_film = $obj_film->dataFilm();
    $data_kursi = $obj_kursi->dataKursi();

    $sesi = $_SESSION['USERS'] ?? null;
    if(isset($sesi) && ($sesi['role'] == 'admin' || $sesi['role'] == 'staff') ){ // Hanya admin dan staff yang bisa akses
?>

<section class="page-title bg-title overlay-dark">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center">
                <div class="title mt-5">
                    <h3>Input Data Tiket</h3>
                </div>
                <ol class="breadcrumb justify-content-center p-0 m-0">
                    <li class="breadcrumb-item"><a href="index.php?hal=home">Home</a></li>
                    <li class="breadcrumb-item active">Data Bioskop</li>
                    <li class="breadcrumb-item active">Data Tiket</li>
                    <li class="breadcrumb-item active">Input Data Tiket</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="section contact-form">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="section-title">
                    <h3>Input <span class="alternate">Data Tiket</span></h3>
                </div>
            </div>
        </div>
        <form action="controllers/TiketController.php" method="POST" class="row">
            <div class="col-md-6 mt-5">
                <label class="form-label fw-bold" for="harga">Harga</label>
                <input type="number" class="form-control main" name="harga" id="harga" placeholder="Harga Tiket" min="0" required>
            </div>
            <div class="col-md-6 mt-5">
                <label class="form-label fw-bold" for="stok">Stok</label>
                <input type="number" class="form-control main" name="stok" id="stok" placeholder="Stok Tiket" min="0" required>
            </div>
            <div class="col-md-6 mt-5">
                <label class="form-label fw-bold" for="kursi_id">Kursi</label>
                <div class="form-group">
                    <select class="form-control main" name="kursi_id" id="kursi_id" required>
                    <option value="">-- Pilih Kursi --</option>
                        <?php
                            foreach($data_kursi as $kursi){
                        ?>
                        <option value="<?= htmlspecialchars($kursi['id']) ?>"> <?= htmlspecialchars($kursi['nomor']) ?> (Studio: <?= htmlspecialchars($kursi['nama_studio']) ?>) </option>
                        <?php
                            }
                        ?>
                    </select>
                </div>
            </div>
            <div class="col-md-6 mt-5">
                <label class="form-label fw-bold" for="film_id">Film</label>
                <div class="form-group">
                    <select class="form-control main" name="film_id" id="film_id" required>
                    <option value="">-- Pilih Film --</option>
                        <?php
                            foreach($data_film as $film){
                        ?>
                        <option value="<?= htmlspecialchars($film['id']) ?>"> <?= htmlspecialchars($film['judul']) ?> </option>
                        <?php
                            }
                        ?>
                    </select>
                </div>
            </div>

            <div class="col-12 text-center mt-4">
                <button type="submit" name="proses" value="simpan" class="btn btn-success btn-md m-3">Simpan</button>
                <button type="submit" name="proses" value="batal" class="btn btn-danger btn-md ">Batal</button>
            </div>
        </form>
    </div>
</section>
<?php 
    }
    else{
        // Jika tidak punya hak akses, arahkan kembali ke halaman login_form.php dengan pesan error
        echo '<script>alert("Anda Dilarang Akses Halaman Ini !!!");history.back();</script>';
    }
?>