<?php
    //ciptakan object dari class Tiket, Film, dan Kursi
    $obj_tiket = new Tiket();
    $obj_film = new Film();
    $obj_kursi = new Kursi();
    
    //panggil fungsi untuk menampilkan data film dan kursi
    $data_film = $obj_film->dataFilm();
    $data_kursi = $obj_kursi->dataKursi();

    //tangkap request idedit di url (setelah klik tombol edit/icon pencil)
    $idedit = htmlspecialchars($_REQUEST['idedit'] ?? '');
    $tiket = !empty($idedit) ? $obj_tiket->getTiket($idedit) : array() ;

    $sesi = $_SESSION['USERS'] ?? null;
    if(isset($sesi) && ($sesi['role'] == 'admin' || $sesi['role'] == 'staff') ){ // Hanya admin dan staff yang bisa akses
?>

<section class="page-title bg-title overlay-dark">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center">
                <div class="title mt-5">
                    <h3>Update Data Tiket</h3>
                </div>
                <ol class="breadcrumb justify-content-center p-0 m-0">
                    <li class="breadcrumb-item"><a href="index.php?hal=home">Home</a></li>
                    <li class="breadcrumb-item active">Data Bioskop</li>
                    <li class="breadcrumb-item active">Data Tiket</li>
                    <li class="breadcrumb-item active">Update Data Tiket</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="section contact-form">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="section-title">
                    <h3>Update <span class="alternate">Data Tiket</span></h3>
                </div>
            </div>
        </div>
        <form action="controllers/TiketController.php" method="POST" class="row">
            <div class="col-md-6 mt-5">
                <label class="form-label fw-bold" for="harga">Harga</label>
                <input type="number" class="form-control main" name="harga" id="harga" placeholder="Harga Tiket"
                value="<?= htmlspecialchars($tiket['harga'] ?? '') ?>" min="0" required>
            </div>
            <div class="col-md-6 mt-5">
                <label class="form-label fw-bold" for="stok">Stok</label>
                <input type="number" class="form-control main" name="stok" id="stok" placeholder="Stok Tiket"
                value="<?= htmlspecialchars($tiket['stok'] ?? '') ?>" min="0" required>
            </div>
            <div class="col-md-6 mt-5">
                <label class="form-label fw-bold" for="kursi_id">Kursi</label>
                <div class="form-group">
                    <select class="form-control main" name="kursi_id" id="kursi_id" required>
                    <option value="">-- Pilih Kursi --</option>
                        <?php
                            foreach($data_kursi as $kursi){
                            $sel = (isset($tiket['kursi_id']) && $tiket['kursi_id'] == $kursi['id']) ? 'selected' : '';
                        ?>
                        <option value="<?= htmlspecialchars($kursi['id']) ?>" <?= $sel ?>> <?= htmlspecialchars($kursi['nomor']) ?> (Studio: <?= htmlspecialchars($kursi['nama_studio']) ?>) </option>
                        <?php
                            }
                        ?>
                    </select>
                </div>
            </div>
            <div class="col-md-6 mt-5">
                <label class="form-label fw-bold" for="film_id">Film</label>
                <div class="form-group">
                    <select class="form-control main" name="film_id" id="film_id" required>
                    <option value="">-- Pilih Film --</option>
                        <?php
                            foreach($data_film as $film){
                            $sel = (isset($tiket['film_id']) && $tiket['film_id'] == $film['id']) ? 'selected' : '';
                        ?>
                        <option value="<?= htmlspecialchars($film['id']) ?>" <?= $sel ?>> <?= htmlspecialchars($film['judul']) ?> </option>
                        <?php
                            }
                        ?>
                    </select>
                </div>
            </div>

            <div class="col-12 text-center mt-4">
                <button type="submit" name="proses" value="ubah" class="btn btn-success btn-md m-3">Ubah</button>
                <input type="hidden" name="idx" value="<?= htmlspecialchars($idedit) ?>">
                <button type="submit" name="proses" value="batal" class="btn btn-danger btn-md ">Batal</button>
            </div>
        </form>
    </div>
</section>
<?php 
    }
    else{
        // Jika tidak punya hak akses, arahkan kembali ke halaman login_form.php dengan pesan error
        echo '<script>alert("Anda Dilarang Akses Halaman Ini !!!");history.back();</script>';
    }
?>