<?php
// views/user_form.php
// View ini digunakan untuk menampilkan formulir penambahan pengguna baru (oleh admin).
// Variabel yang diharapkan: tidak ada, kecuali pesan sesi.

// Pesan sukses atau error dari sesi
if (isset($_SESSION['error_message'])) {
    echo "<p class='message error'>" . htmlspecialchars($_SESSION['error_message']) . "</p>";
    unset($_SESSION['error_message']);
}
if (isset($_SESSION['success_message'])) {
    echo "<p class='message success'>" . htmlspecialchars($_SESSION['success_message']) . "</p>";
    unset($_SESSION['success_message']);
}
?>

<div class="form-container">
    <h1 class="page-title">Tambah Pengguna Baru</h1>
    <p class="page-description">Isi formulir di bawah untuk menambahkan pengguna baru ke sistem.</p>

    <form action="index.php?hal=user_store" method="POST" enctype="multipart/form-data" class="styled-form">
        <div class="form-group">
            <label for="fullname">Nama Lengkap:</label>
            <input type="text" id="fullname" name="fullname" required
                   placeholder="Masukkan nama lengkap pengguna" class="form-control">
        </div>

        <div class="form-group">
            <label for="jenis_kelamin">Jenis Kelamin:</label>
            <select id="jenis_kelamin" name="jenis_kelamin" required class="form-select">
                <option value="">-- Pilih --</option>
                <option value="L">Laki-laki</option>
                <option value="P">Perempuan</option>
            </select>
        </div>

        <div class="form-group">
            <label for="email">Email:</label>
            <input type="email" id="email" name="email" required
                   placeholder="contoh@domain.com" class="form-control">
        </div>

        <div class="form-group">
            <label for="username">Username:</label>
            <input type="text" id="username" name="username" required
                   placeholder="Buat username unik" class="form-control">
        </div>

        <div class="form-group">
            <label for="password">Password:</label>
            <input type="password" id="password" name="password" required
                   placeholder="Masukkan password (minimal 6 karakter)"
                   minlength="6" class="form-control">
        </div>

        <div class="form-group">
            <label for="no_hp">Nomor HP (Opsional):</label>
            <input type="tel" id="no_hp" name="no_hp"
                   placeholder="Contoh: 081234567890" class="form-control">
        </div>

        <div class="form-group">
            <label for="role">Peran (Role):</label>
            <select id="role" name="role" required class="form-select">
                <option value="user">User</option>
                <option value="admin">Admin</option>
            </select>
        </div>

        <div class="form-group">
            <label for="foto">Foto Profil (Opsional):</label>
            <input type="file" id="foto" name="foto" accept="image/*" class="form-control-file">
            <small class="form-text">Ukuran file maksimal 2MB. Format: JPG, PNG, GIF.</small>
        </div>

        <button type="submit" class="btn-submit">
            Tambah Pengguna
        </button>
    </form>
</div>

---

<style>
    /* Global/Base Styles (dari halaman film/user list) */
    body {
        font-family: 'Poppins', sans-serif;
        background-color: #f0f2f5;
        color: #333;
        line-height: 1.6;
        margin: 0;
        padding: 0;
    }

    /* Message Styling (Success/Error) - dari halaman film/user list */
    .message {
        padding: 12px 20px;
        margin: 20px auto;
        border-radius: 8px;
        text-align: center;
        font-weight: 600;
        max-width: 900px;
        box-sizing: border-box;
        animation: fadeInDown 0.5s ease-out;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    @keyframes fadeInDown {
        from { opacity: 0; transform: translateY(-20px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .message.error {
        background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb;
    }
    .message.success {
        background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb;
    }

    /* Main Form Container (mirip main-content-container) */
    .form-container {
        max-width: 600px; /* Lebih kecil dari daftar film/user untuk form */
        margin: 30px auto;
        padding: 30px;
        background-color: #ffffff;
        border-radius: 12px;
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
        animation: fadeIn 0.8s ease-out;
    }
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .page-title {
        text-align: center;
        color: #1a2a3a;
        font-size: 2.5em; /* Sedikit lebih kecil dari page title utama */
        font-weight: 800;
        margin-top: 0;
        margin-bottom: 10px;
        position: relative;
        padding-bottom: 15px;
    }
    .page-title::after {
        content: '';
        width: 60px; /* Lebih pendek untuk judul form */
        height: 4px;
        background-color: #007bff;
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        border-radius: 2px;
    }

    .page-description {
        text-align: center;
        color: #6a737d;
        font-size: 1em;
        margin-bottom: 30px;
        line-height: 1.5;
    }

    /* Form Styling */
    .styled-form {
        display: flex;
        flex-direction: column;
        gap: 20px; /* Jarak antar grup input */
    }

    .form-group {
        display: flex;
        flex-direction: column;
    }

    .form-group label {
        margin-bottom: 8px;
        font-weight: 600;
        color: #555;
        font-size: 1em;
    }

    .form-control,
    .form-select {
        padding: 12px 15px;
        border: 1px solid #ced4da;
        border-radius: 8px; /* Lebih rounded */
        font-size: 1em;
        width: 100%;
        box-sizing: border-box; /* Pastikan padding tidak menambah lebar */
        transition: border-color 0.2s ease, box-shadow 0.2s ease;
        background-color: #fcfcfc;
    }

    .form-control:focus,
    .form-select:focus {
        border-color: #007bff;
        outline: none;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
    }

    .form-select {
        /* Styling khusus untuk dropdown */
        appearance: none; /* Menghilangkan default arrow di beberapa browser */
        -webkit-appearance: none;
        -moz-appearance: none;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 0.75rem center;
        background-size: 16px 12px;
        padding-right: 2.5rem; /* Menyesuaikan ruang untuk ikon */
    }

    .form-control-file {
        padding: 10px 0; /* Padding vertikal untuk input file */
        border: 1px solid #ced4da;
        border-radius: 8px;
        background-color: #f9f9f9;
        font-size: 1em;
    }
    .form-control-file::-webkit-file-upload-button {
        background-color: #e9ecef;
        color: #495057;
        padding: 8px 12px;
        border: none;
        border-radius: 6px;
        cursor: pointer;
        margin-right: 15px;
        transition: background-color 0.2s ease;
    }
    .form-control-file::-webkit-file-upload-button:hover {
        background-color: #dee2e6;
    }

    .form-text {
        font-size: 0.85em;
        color: #6c757d;
        margin-top: 5px;
    }

    .btn-submit {
        padding: 15px 25px;
        background-color: #007bff; /* Warna biru primary */
        color: white;
        border: none;
        border-radius: 8px; /* Lebih rounded */
        font-size: 1.1em;
        font-weight: 600;
        cursor: pointer;
        transition: background-color 0.3s ease, transform 0.2s ease, box-shadow 0.2s ease;
        box-shadow: 0 4px 10px rgba(0, 123, 255, 0.2);
        margin-top: 10px; /* Sedikit jarak dari input terakhir */
    }

    .btn-submit:hover {
        background-color: #0056b3;
        transform: translateY(-2px);
        box-shadow: 0 6px 15px rgba(0, 123, 255, 0.3);
    }

    /* Responsive Adjustments */
    @media (max-width: 768px) {
        .form-container {
            margin: 20px 15px;
            padding: 20px;
        }
        .page-title {
            font-size: 2em;
        }
        .page-description {
            font-size: 0.9em;
        }
        .form-control,
        .form-select,
        .btn-submit {
            font-size: 0.95em;
            padding: 10px 12px;
        }
        .btn-submit {
            padding: 12px 20px;
        }
    }
    @media (max-width: 480px) {
        .form-container {
            padding: 15px;
        }
        .page-title {
            font-size: 1.8em;
            padding-bottom: 10px;
        }
        .page-title::after {
            width: 50px;
            height: 3px;
        }
        .form-group label {
            font-size: 0.9em;
        }
        .form-text {
            font-size: 0.8em;
        }
    }
</style>