<?php
// views/user_form_update.php

if (isset($_SESSION['error_message'])) {
    echo "<p class='message error'>" . htmlspecialchars($_SESSION['error_message']) . "</p>";
    unset($_SESSION['error_message']);
}
if (isset($_SESSION['success_message'])) {
    echo "<p class='message success'>" . htmlspecialchars($_SESSION['success_message']) . "</p>";
    unset($_SESSION['success_message']);
}

if (!isset($user) || !is_array($user)) {
    echo "<p class='message error'>Data pengguna tidak ditemukan untuk diedit.</p>";
    return;
}
?>

<div class="form-container">
    <h1 class="page-title">Edit Profil Pengguna</h1>
    <p class="page-description-sub">
        <?php echo htmlspecialchars($user['fullname']); ?> (<?php echo htmlspecialchars($user['username']); ?>)
    </p>

    <form action="index.php?hal=user_update" method="POST" enctype="multipart/form-data" class="styled-form">
        <input type="hidden" name="id" value="<?php echo htmlspecialchars($user['id']); ?>">
        <input type="hidden" name="old_foto" value="<?php echo htmlspecialchars($user['foto'] ?? ''); ?>">

        <div class="form-group">
            <label for="fullname">Nama Lengkap:</label>
            <input type="text" id="fullname" name="fullname" required
                   value="<?php echo htmlspecialchars($user['fullname']); ?>"
                   class="form-control">
        </div>

        <div class="form-group">
            <label for="jenis_kelamin">Jenis Kelamin:</label>
            <select id="jenis_kelamin" name="jenis_kelamin" required class="form-select">
                <option value="">-- Pilih --</option>
                <option value="L" <?php echo ($user['jenis_kelamin'] == 'L') ? 'selected' : ''; ?>>Laki-laki</option>
                <option value="P" <?php echo ($user['jenis_kelamin'] == 'P') ? 'selected' : ''; ?>>Perempuan</option>
            </select>
        </div>

        <div class="form-group">
            <label for="email">Email:</label>
            <input type="email" id="email" name="email" required
                   value="<?php echo htmlspecialchars($user['email']); ?>"
                   class="form-control">
        </div>

        <div class="form-group">
            <label for="username">Username:</label>
            <input type="text" id="username" name="username" required
                   value="<?php echo htmlspecialchars($user['username']); ?>"
                   class="form-control">
        </div>

        <div class="form-group">
            <label for="password">Password (kosongkan jika tidak diubah):</label>
            <input type="password" id="password" name="password"
                   placeholder="Biarkan kosong jika tidak ingin mengubah password"
                   minlength="6" class="form-control">
            <small class="form-text">Minimal 6 karakter jika diisi.</small>
        </div>

        <div class="form-group">
            <label for="no_hp">Nomor HP (Opsional):</label>
            <input type="tel" id="no_hp" name="no_hp"
                   value="<?php echo htmlspecialchars($user['no_hp'] ?? ''); ?>"
                   class="form-control">
        </div>

        <?php if (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin'): ?>
            <div class="form-group">
                <label for="role">Peran (Role):</label>
                <select id="role" name="role" required class="form-select">
                    <option value="user" <?php echo ($user['role'] == 'user') ? 'selected' : ''; ?>>User</option>
                    <option value="admin" <?php echo ($user['role'] == 'admin') ? 'selected' : ''; ?>>Admin</option>
                </select>
                <small class="form-text">Hanya admin yang dapat mengubah peran.</small>
            </div>
        <?php else: ?>
            <!-- Non-admin tidak bisa mengubah role -->
            <input type="hidden" name="role" value="<?php echo htmlspecialchars($user['role']); ?>">
        <?php endif; ?>

        <div class="form-group">
            <label for="foto">Foto Profil (kosongkan jika tidak diubah):</label>
            <?php
            $profile_pic_path = isset($user['foto']) && $user['foto'] ? "assets/profile/" . htmlspecialchars(basename($user['foto'])) : null;
            ?>
            <?php if ($profile_pic_path && file_exists(dirname(__DIR__) . '/' . $profile_pic_path)): ?>
                <div class="current-photo-preview">
                    <p>Foto Saat Ini:</p>
                    <img src="<?= $profile_pic_path ?>" alt="Foto Profil" class="current-profile-thumbnail">
                </div>
            <?php else: ?>
                <p class="form-text">Belum ada foto profil.</p>
            <?php endif; ?>
            <input type="file" id="foto" name="foto" accept="image/*" class="form-control-file">
            <small class="form-text">Pilih file baru jika ingin mengubah foto. Ukuran maksimal 2MB. Format: JPG, PNG, GIF.</small>
        </div>

        <button type="submit" class="btn-update">Perbarui Profil</button>
    </form>
</div>

<style>
    /* Global/Base Styles (dari halaman film/user list/detail) */
    body {
        font-family: 'Poppins', sans-serif;
        background-color: #f0f2f5;
        color: #333;
        line-height: 1.6;
        margin: 0;
        padding: 0;
    }

    /* Message Styling (Success/Error) - dari halaman film/user list/detail */
    .message {
        padding: 12px 20px;
        margin: 20px auto;
        border-radius: 8px;
        text-align: center;
        font-weight: 600;
        max-width: 900px;
        box-sizing: border-box;
        animation: fadeInDown 0.5s ease-out;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    @keyframes fadeInDown {
        from { opacity: 0; transform: translateY(-20px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .message.error {
        background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb;
    }
    .message.success {
        background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb;
    }

    /* Main Form Container (dari user_form.php) */
    .form-container {
        max-width: 600px;
        margin: 30px auto;
        padding: 30px;
        background-color: #ffffff;
        border-radius: 12px;
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
        animation: fadeIn 0.8s ease-out;
    }
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .page-title {
        text-align: center;
        color: #1a2a3a;
        font-size: 2.5em;
        font-weight: 800;
        margin-top: 0;
        margin-bottom: 10px;
        position: relative;
        padding-bottom: 15px;
    }
    .page-title::after {
        content: '';
        width: 60px;
        height: 4px;
        background-color: #007bff;
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        border-radius: 2px;
    }

    .page-description-sub { /* Baru untuk sub-judul seperti nama user */
        text-align: center;
        color: #6a737d;
        font-size: 1.2em; /* Lebih besar dari page-description biasa */
        margin-bottom: 30px;
        line-height: 1.5;
        font-weight: 500;
    }

    /* Form Styling (dari user_form.php) */
    .styled-form {
        display: flex;
        flex-direction: column;
        gap: 20px;
    }

    .form-group {
        display: flex;
        flex-direction: column;
    }

    .form-group label {
        margin-bottom: 8px;
        font-weight: 600;
        color: #555;
        font-size: 1em;
    }

    .form-control,
    .form-select {
        padding: 12px 15px;
        border: 1px solid #ced4da;
        border-radius: 8px;
        font-size: 1em;
        width: 100%;
        box-sizing: border-box;
        transition: border-color 0.2s ease, box-shadow 0.2s ease;
        background-color: #fcfcfc;
    }

    .form-control:focus,
    .form-select:focus {
        border-color: #007bff;
        outline: none;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
    }

    .form-select {
        appearance: none;
        -webkit-appearance: none;
        -moz-appearance: none;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 0.75rem center;
        background-size: 16px 12px;
        padding-right: 2.5rem;
    }

    .form-control-file {
        padding: 10px 0;
        border: 1px solid #ced4da;
        border-radius: 8px;
        background-color: #f9f9f9;
        font-size: 1em;
    }
    .form-control-file::-webkit-file-upload-button {
        background-color: #e9ecef;
        color: #495057;
        padding: 8px 12px;
        border: none;
        border-radius: 6px;
        cursor: pointer;
        margin-right: 15px;
        transition: background-color 0.2s ease;
    }
    .form-control-file::-webkit-file-upload-button:hover {
        background-color: #dee2e6;
    }

    .form-text {
        font-size: 0.85em;
        color: #6c757d;
        margin-top: 5px;
    }

    /* Current Photo Preview */
    .current-photo-preview {
        display: flex;
        align-items: center;
        gap: 15px;
        margin-bottom: 15px;
        background-color: #f0f2f5;
        padding: 10px 15px;
        border-radius: 8px;
        border: 1px solid #e0e0e0;
    }
    .current-photo-preview p {
        margin: 0;
        font-weight: 600;
        color: #555;
    }
    .current-profile-thumbnail {
        width: 80px;
        height: 80px;
        border-radius: 50%;
        object-fit: cover;
        border: 2px solid #007bff;
        box-shadow: 0 2px 8px rgba(0, 123, 255, 0.1);
    }

    /* Update Button */
    .btn-update { /* Baru, mirip btn-submit tapi warna berbeda */
        padding: 15px 25px;
        background-color: #28a745; /* Green for update action */
        color: white;
        border: none;
        border-radius: 8px;
        font-size: 1.1em;
        font-weight: 600;
        cursor: pointer;
        transition: background-color 0.3s ease, transform 0.2s ease, box-shadow 0.2s ease;
        box-shadow: 0 4px 10px rgba(40, 167, 69, 0.2); /* Shadow with green tint */
        margin-top: 10px;
    }

    .btn-update:hover {
        background-color: #218838; /* Darker green on hover */
        transform: translateY(-2px);
        box-shadow: 0 6px 15px rgba(40, 167, 69, 0.3);
    }

    /* Responsive Adjustments (dari user_form.php) */
    @media (max-width: 768px) {
        .form-container {
            margin: 20px 15px;
            padding: 20px;
        }
        .page-title {
            font-size: 2.2em;
        }
        .page-description-sub {
            font-size: 1.1em;
        }
        .form-control,
        .form-select,
        .btn-update {
            font-size: 0.95em;
            padding: 10px 12px;
        }
        .btn-update {
            padding: 12px 20px;
        }
        .current-photo-preview {
            flex-direction: column;
            align-items: flex-start;
            gap: 10px;
        }
    }
    @media (max-width: 480px) {
        .form-container {
            padding: 15px;
        }
        .page-title {
            font-size: 2em;
            padding-bottom: 10px;
        }
        .page-title::after {
            width: 50px;
            height: 3px;
        }
        .page-description-sub {
            font-size: 1em;
        }
        .form-group label {
            font-size: 0.9em;
        }
        .form-text {
            font-size: 0.8em;
        }
        .current-profile-thumbnail {
            width: 60px;
            height: 60px;
        }
    }
</style>